#ifndef _CLUSTER_HH_
#define _CLUSTER_HH_

#include "JetCore/LorentzVector.hh"

#include "PhysicsTower.hh"
#include "Centroid.hh"
#include <vector>
#include <cmath>
#include <iostream>
using namespace std;

namespace SpartyJet { 
class Cluster
{
 public:
  std::vector<PhysicsTower> towerList;
  LorentzVector fourVector;
  Centroid centroid;
  bool split_merged;

  Cluster()
  {
    clear();
  }
  void clear()
  {
    split_merged = false;
    towerList.clear();
    fourVector = LorentzVector();
    centroid = Centroid();
  }
  void addTower(PhysicsTower p)
  {
    towerList.push_back(p);
    fourVector.add(p.fourVector);
    centroid.add(Centroid(p.Et(),p.eta(),p.phi()));
  }
  void removeTower(PhysicsTower p)
  {
    for(std::vector<PhysicsTower>::iterator towerIter = towerList.begin(); towerIter != towerList.end(); towerIter++)
      if(towerIter->isEqual(p)){
	fourVector.subtract(towerIter->fourVector);
	centroid.subtract(Centroid(towerIter->Et(),towerIter->eta(),towerIter->phi()));
	towerList.erase(towerIter);
	break;
      }
  }
  int size(){return towerList.size();}

  double mass() {
    double tmass = 0.0;
    double t;
    double tpx,tpy,tpz,te;
    tpx = tpy = tpz = te = 0.0;
    for(unsigned int i = 0; i < towerList.size(); i++) {
      tpx += towerList[i].fourVector.px();
      tpy += towerList[i].fourVector.py();     
      tpz += towerList[i].fourVector.pz();
      te += towerList[i].fourVector.E();
    }
    t = pow(te,2) - pow(tpx,2) - pow(tpy,2) - pow(tpz,2);
    if(t < 0) tmass = 0;
    else tmass = pow(t,0.5);
   
    return tmass;
  }

};

}  // namespace SpartyJet
#endif
