#include "JetClustFinder.hh"
#include "JetCore/CommonUtils.hh"
namespace SpartyJet { 

namespace cdf {

void JetClustFinder::configure(double st,double cr,int ac,int mi,int ir,double ot){
  seedThreshold      = st;
  coneRadius         = cr;
  adjacencyCut       = ac;
  maxIterations      = mi;
  iratch             = ir;
  overlapThreshold   = ot;
}
  
void JetClustFinder::init(JetMomentMap *mmap) {
  if(mmap != NULL) {
    if(saveSplitMerged) mmap->schedule_jet_moment("split_merged");   
  }
}

void JetClustFinder::execute(JetCollection &inputJets) {

  JetCollection tmp_list;
  
	// retrieve the map of the collection :
  JetMomentMap * themap = tmp_list.get_JetMomentMap();
	// Copy Jet moment layout from input
	themap->copy_structure(*(inputJets.get_JetMomentMap()));
  
	if (saveSplitMerged && (themap->num_jet_moment() ==0)) return;

  int split_merged_pos = 0;
  if(saveSplitMerged) split_merged_pos = themap->get_jet_momentPos("split_merged");

  JetCollection::iterator iter = inputJets.begin();

  // convert jetlist to clusters and clear inputJets
  vector<PhysicsTower> towers;
  Jet *tjet = NULL;
	int ind=0;
  while(iter != inputJets.end()){
    tjet = *iter;
    // Build a tower with index (a spartyjet modif):
    PhysicsTower t(LorentzVector(tjet->px(),tjet->py(),tjet->pz(),tjet->E()), ind);
    towers.push_back(t);
    iter++;ind++;
  }
  
  // run the algorithm
  vector<Cluster> jets;
  JetCluAlgorithm j(seedThreshold,coneRadius,
		    adjacencyCut,maxIterations,
		    iratch,overlapThreshold);
  j.run(towers,jets);
  
  // convert output to jets
  std::vector<Cluster>::iterator clusteriter = jets.begin();
  Jet *t2jet;
  for( ; clusteriter != jets.end(); clusteriter++) {
    t2jet = new Jet(clusteriter->fourVector);

    if(saveSplitMerged) {
      themap->set_jet_moment(split_merged_pos,t2jet,(float)clusteriter->split_merged);//  split/merged
    }

    // add constituents to jet
    std::vector<PhysicsTower>::iterator constiter = clusteriter->towerList.begin();
    for( ; constiter != clusteriter->towerList.end(); constiter++) {
      int index = constiter->m_index;
      t2jet->addConstituent_notMoment( *(inputJets[index]->firstConstituent()) );
    }    
    tmp_list.push_back(t2jet);
  }
  // we can now delete the input collection :
  clear_list(inputJets);
  // and update it :
  inputJets.swap(tmp_list);
  

}

}  // namespace SpartyJet
}
