#ifndef _JETCLUSTFINDER_HH_
#define _JETCLUSTFINDER_HH_

#include "JetCore/JetTool.hh"
#include "Cluster.hh"
#include "PhysicsTower.hh"
#include "JetCluAlgorithm.hh"
#include <string>
namespace SpartyJet { 

namespace cdf {

class JetClustFinder : public JetTool {
public :
  JetClustFinder(std::string name = "myJetClust") {
    seedThreshold      = 1;
    coneRadius         = 0.7;
    adjacencyCut       = 2;
    maxIterations      = 100;
    iratch             = 1;
    overlapThreshold   = 0.75;
    saveSplitMerged    = false;
    m_name = name;
  };

  void init(JetMomentMap *mmap=0);

  void configure(double,double,int,int,int,double);
  void set_seedThreshold(double x)    {seedThreshold    = x;}
  void set_coneRadius(double x)       {coneRadius       = x;}
  void set_adjacencyCut(int x)        {adjacencyCut     = x;}
  void set_maxIterations(int x)       {maxIterations    = x;}
  void set_iratch(int x)              {iratch           = x;}
  void set_overlapThreshold(double x) {overlapThreshold = x;}
  void set_name(std::string n)        {m_name = n;}
  void set_saveSplitMerged(bool x)    {saveSplitMerged  = x;}
  double getConeRadius()              {return coneRadius;}

  virtual void execute(JetCollection &inputJets);
  
protected:

  bool   saveSplitMerged;
  double seedThreshold;
  double coneRadius;
  int    adjacencyCut;
  int    maxIterations;
  int    iratch;
  double overlapThreshold;

};

class JetCluFinder : public JetClustFinder {
public:
  JetCluFinder(std::string name = "myJetClu") : JetClustFinder(name) {};
  
};

}

}  // namespace SpartyJet
#endif
