#ifndef _MIDPOINT_ALGORITHM_HH_
#define _MIDPOINT_ALGORITHM_HH_

#include "PhysicsTower.hh"
#include "Cluster.hh"
#include <vector>

namespace SpartyJet { 
class MidPointAlgorithm
{
 private:
  double _seedThreshold;
  double _coneRadius;
  double _coneAreaFraction;
  int    _maxPairSize;
  int    _maxIterations;
  double _overlapThreshold;
  bool   _reduceConeSize;

 public:
  MidPointAlgorithm():
    _seedThreshold(1),
    _coneRadius(0.7),
    _coneAreaFraction(0.25),
    _maxPairSize(2),
    _maxIterations(100),
    _overlapThreshold(0.75),
    _reduceConeSize(false)
  {}
  MidPointAlgorithm(double st, double cr, double caf, int mps, int mi, double ot, bool rc):
    _seedThreshold(st),
    _coneRadius(cr),
    _coneAreaFraction(caf),
    _maxPairSize(mps),
    _maxIterations(mi),
    _overlapThreshold(ot),
    _reduceConeSize(rc)
  {}

  void findStableConesFromSeeds(std::vector<PhysicsTower>& particles, std::vector<Cluster>& stableCones);
  void findStableConesFromMidPoints(std::vector<PhysicsTower>& particles, std::vector<Cluster>& stableCones);
  void iterateCone(double startRapidity, double startPhi, double startPt, std::vector<PhysicsTower>& particles,
		   std::vector<Cluster>& stableCones);
  void addClustersToPairs(std::vector<int>& testPair, std::vector< std::vector<int> >& pairs,
			  std::vector< std::vector<bool> >& distanceOK, int maxClustersInPair);
  void splitAndMerge(std::vector<Cluster>& stableCones, std::vector<Cluster>& jets);
  void run(std::vector<PhysicsTower>& particles, std::vector<Cluster>& jets);
};

}  // namespace SpartyJet
#endif
