#include "MidPointFinder.hh"
#include "JetCore/CommonUtils.hh"
namespace SpartyJet { 

namespace cdf {

void MidPointFinder::configure(bool sp,double st,double cr,double caf,int mps,int mi,double ot,int rcs) {
  seedThreshold    = st;
  coneRadius       = cr;
  coneAreaFraction = caf;
  maxPairSize      = mps;
  maxIterations    = mi;
  overlapThreshold = ot;
  reduceConeSize   = rcs;
  
  do_second_pass   = sp;
  init();
}

void MidPointFinder::init(JetMomentMap *mmap) {
  if(mmap != NULL) {
    if(savePassNum) mmap->schedule_jet_moment("pass_num");
    if(saveSplitMerged) mmap->schedule_jet_moment("split_merged");   
  }
}

void MidPointFinder::execute(JetCollection &inputJets) {

  JetCollection tmp_list;
  
	// retrieve the map of the collection :
  JetMomentMap * themap = tmp_list.get_JetMomentMap();
	// Copy Jet moment layout from input
	themap->copy_structure(*(inputJets.get_JetMomentMap()));

  if ((savePassNum || saveSplitMerged) && (themap->num_jet_moment()==0)) return;
  
  // retrieve position of moments in map
  int pass_num_pos = 0;
  if(savePassNum) pass_num_pos = themap->get_jet_momentPos("pass_num");
  unsigned last_first_pass;
  int split_merged_pos = 0;
  if(saveSplitMerged) split_merged_pos = themap->get_jet_momentPos("split_merged");


  JetCollection::iterator iter = inputJets.begin();
  
  // convert jetlist to clusters and clear inputJets
  vector<PhysicsTower> towers;
  Jet *tjet = NULL;
  int ind=0;
	while(iter != inputJets.end()){
    tjet = *iter;
    // Build a tower with index (a spartyjet modif):
    	towers.push_back(PhysicsTower(LorentzVector(tjet->px(),tjet->py(),tjet->pz(),tjet->E()),ind));
    iter++;ind++;
  }
  
  // run the algorithm
  vector<Cluster> jets;
  MidPointAlgorithm m(seedThreshold,coneRadius,
		      coneAreaFraction, maxPairSize,
		      maxIterations,overlapThreshold,
		      reduceConeSize);
  m.run(towers,jets);
  std::vector<Cluster>::iterator clusteriter;
  last_first_pass = jets.size();

  // run second pass if turned on
  if(do_second_pass) {
    vector<PhysicsTower> towers2 = towers;
    vector<Cluster> jets2;
    int found = 0;
    
    vector<Cluster>::iterator jetIter = jets.begin();
    for( ; jetIter != jets.end(); jetIter++) {
      vector<PhysicsTower>::iterator rtowerIter = jetIter->towerList.begin();
      for( ; rtowerIter != jetIter->towerList.end(); rtowerIter++) {
	
	found = 0;
	
	vector<PhysicsTower>::iterator otowerIter = towers2.begin();
	for( ; otowerIter != towers2.end(); otowerIter++) {
	  
	  if(otowerIter->isEqual(*rtowerIter)) {
	    towers2.erase(otowerIter);
	    found = 1;
	  }
	  if(found == 1) break;
	}
      }
    }    // all towers in jets have now been removed
    
    // do a second pass with remaining towers
    m.run(towers2,jets2);
    
    // combine jets2 and jets;
    clusteriter = jets2.begin();
    for( ; clusteriter != jets2.end(); clusteriter++)
      jets.push_back(*clusteriter);
  }
  
  // convert output to jets
  clusteriter = jets.begin();
  std::vector<PhysicsTower>::iterator constiter;
  Jet *t2jet;
  for( ; clusteriter != jets.end(); clusteriter++) {
    t2jet = new Jet(clusteriter->fourVector);
    
    if(saveSplitMerged) {
      themap->set_jet_moment(split_merged_pos,t2jet,(float)clusteriter->split_merged);//  split/merged
    }

    // set jet moment "pass_num" if second pass is turned on
    if(savePassNum) {
      if(tmp_list.size() < last_first_pass)
	themap->set_jet_moment(pass_num_pos,t2jet,1);   // first pass jet
      else
	themap->set_jet_moment(pass_num_pos,t2jet,2);   // second pass jet
    }

    // add constituents to jet
    constiter = clusteriter->towerList.begin();
    for( ; constiter != clusteriter->towerList.end(); constiter++) {
      int index = constiter->m_index;
      t2jet->addConstituent_notMoment( *(inputJets[index]->firstConstituent()) );
    }
    tmp_list.push_back(t2jet);
  }

  // we can now delete the input collection :
  clear_list(inputJets);
  // and update it :
  inputJets.swap(tmp_list);


}


}  // namespace SpartyJet
}
