#ifndef _MIDPOINTFINDER_HH_
#define _MIDPOINTFINDER_HH_

#include "JetCore/JetTool.hh"
#include "Cluster.hh"
#include "PhysicsTower.hh"
#include "MidPointAlgorithm.hh"
#include <string>
namespace SpartyJet { 

class JetMomentMap;
namespace cdf {

class MidPointFinder : public JetTool {
public :
  MidPointFinder(std::string name = "myMidPoint",bool sp = false) {
    seedThreshold      = 1;
    coneRadius         = 0.7;
    coneAreaFraction   = 0.25;
    maxPairSize        = 2;
    maxIterations      = 100;
    overlapThreshold   = 0.75;
    reduceConeSize     = 0;
    savePassNum        = sp;
    saveSplitMerged    = false;

    set_second_pass(sp);
    m_name = name;
    init();
  };

  void configure(bool,double,double,double,int,int,double,int);
  void set_second_pass(bool x)        {do_second_pass   = x;}
  void set_seedThreshold(double x)    {seedThreshold    = x; init();}
  void set_coneRadius(double x)       {coneRadius       = x;}
  void set_coneAreaFraction(double x) {coneAreaFraction = x;}
  void set_maxPairSize(int x)         {maxPairSize      = x;}
  void set_maxIterations(int x)       {maxIterations    = x;}
  void set_overlapThreshold(double x) {overlapThreshold = x;}
  void set_reduceConeSize(int x)      {reduceConeSize   = x;}
  void set_name(std::string n)        {m_name = n;}
  void set_savePassNum(bool x)        {savePassNum      = x;}
  void set_saveSplitMerged(bool x)    {saveSplitMerged  = x;}
  double getConeRadius()              {return coneRadius;}

  virtual void init(JetMomentMap *mmap=0);
  virtual void execute(JetCollection &inputJets);

protected:
  
  bool   saveSplitMerged;
  bool   savePassNum;
  bool   do_second_pass;
  double seedThreshold;
  double coneRadius;
  double coneAreaFraction;
  int    maxPairSize;
  int    maxIterations;
  double overlapThreshold;
  int    reduceConeSize; 
};

}

}  // namespace SpartyJet
#endif
