#ifndef _PHYSICS_TOWER_HH_
#define _PHYSICS_TOWER_HH_

#include "JetCore/LorentzVector.hh"
#include "CalTower.hh"

namespace SpartyJet { 
class PhysicsTower
{
 public:
  int m_index ; // spartyjet modif
  LorentzVector fourVector;
  CalTower calTower;



  PhysicsTower(): m_index(-1), fourVector(LorentzVector()), calTower(CalTower()) {}// spartyjet modif
  PhysicsTower(LorentzVector v, CalTower c): m_index(-1), fourVector(v), calTower(c) {} // spartyjet modif
  PhysicsTower(const PhysicsTower& p): m_index(p.m_index),fourVector(p.fourVector), calTower(p.calTower) {} // spartyjet modif
  PhysicsTower(CalTower c):
    fourVector(LorentzVector(c.Et*cos(c.phi),c.Et*sin(c.phi),c.Et*sinh(c.eta),c.Et*cosh(c.eta))), calTower(c) {}
  PhysicsTower(LorentzVector v, int index=-1):m_index(index), fourVector(v), calTower(CalTower(v.Et(),v.eta(),v.phi())) {} // spartyjet modif
  double Et()   const {return calTower.Et;}
  double eta()  const {return calTower.eta;}
  double phi()  const {return calTower.phi;}
  int    iEta() const {return calTower.iEta;}
  int    iPhi() const {return calTower.iPhi;}
  bool isEqual(PhysicsTower p)
  {
    return fourVector.isEqual(p.fourVector) && calTower.isEqual(p.calTower);
  }
};

}  // namespace SpartyJet
#endif
