#include "CellJetFinder.hh"
namespace SpartyJet { 

namespace pythia {

void CellJetFinder::configure(double m,double cr,double s) {
  eTjetMinIn   = m;
  coneRadiusIn = cr;
  eTseedIn     = s;
}

void CellJetFinder::execute(JetCollection &inputJets) {
  
  JetCollection::iterator iter = inputJets.begin();
  
  // convert jetlist to celljet information and clear inputJets
  Pythia8::CellJetEvent cj_Event;
  Pythia8::Particle temp_CJparticle;
  Jet *tjet = NULL;
  while(iter != inputJets.end()){
    tjet = *iter;
		temp_CJparticle.p(tjet->px(),tjet->py(),tjet->pz(),tjet->E());
		temp_CJparticle.id(1);
		cj_Event.append(temp_CJparticle);
    iter = inputJets.erase(iter);
    delete tjet;
  }
  
  // run the algorithm
  std::vector<Pythia8::SingleCellJet> jets;
  Pythia8::CellJet celljet;
  celljet.analyze(cj_Event,eTjetMinIn,coneRadiusIn,eTseedIn);
  jets = celljet.get_jets();

  // convert output to jets
  std::vector<Pythia8::SingleCellJet>::iterator cjiter = jets.begin();
  for( ; cjiter != jets.end(); cjiter++)
    inputJets.push_back( new Jet(cjiter->pMassive.px(),
				 cjiter->pMassive.py(),
				 cjiter->pMassive.pz(),
				 cjiter->pMassive.e()) );

}

}  // namespace SpartyJet
}
