#ifndef _CELLJETFINDER_HH_
#define _CELLJETFINDER_HH_

#include "JetCore/JetTool.hh"
#include "CellJet.hh"
#include "Basics.hh"
#include <string>
namespace SpartyJet { 

namespace pythia {

class CellJetFinder : public JetTool {
public :
  CellJetFinder(std::string name = "myCellJet") {
    eTjetMinIn        = 0;
    coneRadiusIn      = 0.7;
    eTseedIn          = 1.5;  
    m_name = name;
  }
  void configure(double,double,double);
  void set_minEt(double x)     {eTjetMinIn   = x;}
  void set_coneRadius(double x){coneRadiusIn = x;}
  void set_seedEt(double x)    {eTseedIn     = x;} 
  void set_name(std::string n) {m_name       = n;}

  double getConeRadius()       {return coneRadiusIn;}

  virtual void execute(JetCollection &inputJets);

protected:
  double eTjetMinIn;
  double coneRadiusIn;
  double eTseedIn;
};
}

}  // namespace SpartyJet
#endif
