#ifndef _JETCOLLEXTENDED_H
#define _JETCOLLEXTENDED_H


#include <string>
#include <vector>
#include "JetCore/JetCollection.hh"

namespace SpartyJet { 

class JetCollExtended : public JetCollection {
public:

  JetCollExtended() : JetCollection() {
    m_algname = ""; m_colorCode = 0; m_radius = 0.0;}

  JetCollExtended(const JetCollExtended & t) : JetCollection(t) {
    m_algname = ""; m_colorCode = 0; m_radius = 0.0;}

  std::string name()   {return m_algname;}
  int    color()  {return m_colorCode;}
  float  radius() {return m_radius;}

  void debug();

  void clear_and_delete(){ m_algoIndices.clear(); JetCollection::clear_and_delete();};
  std::vector<int>  m_algoIndices;

  void set_algo_indices(size_t num);

protected:
  std::string m_algname;
  int m_colorCode;
  float m_radius;

};
}  // namespace SpartyJet
#endif
