#ifndef _JETCOLLREADERBASE_H
#define _JETCOLLREADERBASE_H


#include <string>
using namespace std;
#include <vector>
#include <iostream>
using namespace std;

#include "JetCore/JetCollection.hh"
#include "JetCore/TreeBranchUtils.hh"
#include "JetInputCollection.hh"

#include <TTree.h>



namespace SpartyJet { 

  class IJetCollReader {
  public:
    virtual ~IJetCollReader() {};
		virtual void fill_collection(JetCollection & JetColl)= 0 ;
    
    virtual void fill_inputIndices(vector<int> & ind_vect, int num_input)= 0 ;
    virtual void fill_constituents(JetCollection &jets, JetInputCollection & constits ) = 0 ;
    
    virtual void init(TTree * tree)= 0 ;

    virtual void set_var_names(string v1,string v2,string v3,string v4) = 0;
    //virtual void set_var_jetN_name(string v) = 0;

    virtual void set_name(string name) = 0 ;
    virtual string name() = 0;
    
    virtual void GetEntry(int i) = 0;
    
    virtual void set_reject_bad_input(bool) = 0;

  };

#define NMAXJETS  10000
  template<class BType, class BIndex>
  class EtaPhiPtECollection_index : public EtaPhiPtECollection< BType >, public IJetCollReader {
  public:
    EtaPhiPtECollection_index(TString base,TString suffix="") : EtaPhiPtECollection<BType> (base, suffix) {
      this->m_prefix +="_"; // Needed for gui !!
      this->set_var_names("eta","phi","pt","e");
      this->set_n_name("N");
      m_ind.m_name = this->m_prefix + "ind" +this->m_suffix;
      this->add_var( &m_ind );
    };

    void set_ind_name(TString n){ m_ind.m_name = this->m_prefix + "ind" + this->m_suffix; }
    virtual void fill_collection(JetCollection & JetColl){
      //cout<< "EtaPhiPtECollection_index "<< this->m_prefix<< " fill_collection "<< endl;
      this->EtaPhiPtECollection<BType>::fill_collection( (Jet::jet_list_t&) JetColl) ;}
    
    virtual void fill_inputIndices(vector<int> & ind_vect, int num_input){
      ind_vect.resize(num_input);
        for(int i=0;i< num_input; i++){ ind_vect[i] = m_ind[i] ; }
    }
    virtual void fill_constituents(JetCollection &jets, JetInputCollection & constits ){
      // assume collection have been correctly filled before
      unsigned int nconstit = constits.size();
      //unsigned int njet = jets.size();      
      for(unsigned int i=0;i< nconstit; i++){
	//cout<< i<<"  "<< m_ind[i]<< " / "<< njet <<endl;
	if(m_ind[i]>-1) jets[m_ind[i]]->addConstituent_notMoment(constits[i]);
      } 
    }


    virtual void set_var_names(string v1,string v2,string v3,string v4) {
      this->EtaPhiPtECollection<BType>::set_var_names(v1,v2,v3,v4);
    };    
    virtual void init(TTree * tree) { this->SetBranchAddress(tree);} 
    virtual void set_name(string name) { this->m_prefix=name.c_str();};
    virtual string name() {return string((const char*)this->m_prefix);} ;

    virtual void GetEntry(int i ) {this->EtaPhiPtECollection<BType>::GetEntry(i);};

    
    virtual void set_reject_bad_input(bool b){this->EtaPhiPtECollection<BType>::set_reject_bad_input(b);}
    
  protected:
    //BranchWrap_array< int, NMAXJETS > m_ind;
    BIndex m_ind;
  };


}  // namespace SpartyJet
#endif
