#include "display/JetHistoryView.hh"
#include "display/EventView.hh"

namespace SpartyJet { 
  
  
  void JetHistoryView::init(HistoryElement &el)  {

    HistoryProvider<JetHistoryView>::init(el);
    history.item = this;
    SetMarkerStyle(20);
    SetMarkerColor(0);
    SetMarkerSize(1);

  }

  void JetHistoryView::buildJet(){
    Jet* j = getJet();
    SetX(j->eta());
    SetY(j->phi());
  }

  void JetHistoryView::debug(){
    std::cout << " JHV  "<< this << "  item="<< history.item << "  hind"<< hindex() << "  jet "<< jet() << std::endl;
  }
  

#define LOOP_OVER_CONSTIT( code )   hist_list_t constits; retrieveParentNodes(constits,true,false) ; \
  hist_list_t::iterator it = constits.begin();\
  hist_list_t::iterator itE = constits.end(); \
  for(; it != itE; ++it){ code }

  void JetHistoryView::drawConstituents(int color, int style, float size){    
    TAttMarker m(color,style,size);
    //std::cout << " drawConstituents  "; debug();
    //LOOP_OVER_CONSTIT(  std::cout << " --> it="<< *it<< "  "; (*it)->debug();  (*it)->drawJet(m); ) ;
    LOOP_OVER_CONSTIT(   (*it)->drawJet(m); ) ;
  }


  void JetHistoryView::setConstitutentAtt(TAttMarker &m){
    LOOP_OVER_CONSTIT( m.Copy( *(*it) ) ; ) ;
  }
  void JetHistoryView::setConstitutentStyle(int style){
    LOOP_OVER_CONSTIT( (*it)->SetMarkerStyle( style ) ; ) ;
  }
  void JetHistoryView::setConstitutentColor(int color){
    LOOP_OVER_CONSTIT( (*it)->SetMarkerColor( color ) ; ) ;
  }
  void JetHistoryView::setConstitutentSize(float size){
    LOOP_OVER_CONSTIT(  (*it)->SetMarkerSize( size ) ; ) ;
  }

  


  void JetHistoryView::drawParent(int color, int style, float size){
    TAttMarker m(color,style,size);
    if(parent1()) parent1()->Draw(m);
    if(parent2()) parent2()->Draw(m);
  }





  // ////////////////////////////////////////////////////////////////
  // ////////////////////////////////////////////////////////////////

  JetHistViewCollection::JetHistViewCollection(JetCollection &jcoll){
    
    if ( ! jcoll.has_history() ) return;

    std::vector< HistoryElement> &history = * jcoll.history();
    size_t Hsize = history.size();
    m_hview.clear(); m_hview.resize(Hsize);
    m_finaljet_hview.clear();

    // make the JetHistoryView pointers point to JetHistoryView and not simple HistoryElement
    for(size_t i=0;i< Hsize; i++ ){
      JetHistoryView &hv =  m_hview[i];      
      HistoryElement &el = history[i];

      m_hview[i].init( history[i] ) ;
      
      if( el.parent1() ){ hv.setParent1( &m_hview[el.parent1()->hindex()]) ;}
      if( el.parent2() ){ hv.setParent2( &m_hview[el.parent2()->hindex()]);}
      if( el.child() )  { hv.setChild  ( &m_hview[el.child()->hindex()]);  }
      //std::cout<< std::endl;

      hv.buildJet(); // rebuild jet if necessary
      //std::cout<< "JetHistViewCollection "<< i << " hindex="<< hv.hnode.hindex <<"  item "<<hv.hnode.item << "  hv "<< &hv << std::endl;
    }

    // fill the vector of pointers to history of final jets
    // this vector has the size of the jet collection
    m_finaljet_hview.resize(jcoll.size() );
    m_singleconstit_hview.reserve(jcoll.size()) ;
    for(size_t i = 0 ; i< jcoll.size(); i++){
      int hind = jcoll[i]->historyIndex();
      JetHistoryView * hv = &m_hview[hind];      
      if(!hv->parent1() ){
        // this final jet is also a pure constituent

        // std::cout<< i<< " final jet hindex= " << hv->hnode.hindex << " pure constit "<< std::endl;
        m_singleconstit_hview.push_back(JetHistoryView());
        JetHistoryView &newhv = m_singleconstit_hview.back() ;
        newhv.init(history[hind] );
        newhv.setParent1( hv );
        newhv.buildJet();
        hv = & newhv;
      }
      m_finaljet_hview[i] = hv;
      
    }

    // std::string hname = "AA";
    // m_baseH.SetBins(10,-5.2,5.2,10,-3.2,3.2);
  }


  void JetHistViewCollection::drawConstituents(bool onlyFinalJet){

    if(onlyFinalJet) {
      
      for(size_t i = 0 ; i< m_finaljet_hview.size(); i++){
        //std::cout << i << "  ...  "<< std::endl;
        m_finaljet_hview[i]->drawConstituents(EventViewBase::option_low_pt_jet_color);
      }
    } else {
      for(size_t i=0;i< m_hview.size(); i++ ){
        JetHistoryView &hv =  m_hview[i];      
        if(! hv.parent1() ) hv.drawJet(EventViewBase::option_low_pt_jet_color);
      }
    }

  }

  std::vector<JetHistoryView*> JetHistViewCollection::historyNoConstituent(){
    std::vector<JetHistoryView*> hvec;
    for(size_t i=0;i< m_hview.size(); i++ ){ if(m_hview[i].parent1()) hvec.push_back(&m_hview[i]);}
    return hvec;
  }

}
