#ifndef _JET_HISTORYVIEW_HH_
#define _JET_HISTORYVIEW_HH_

#include "JetCore/JetCollection.hh"
#include "JetCore/JetHistory.hh"
#include "display/Jet2DView.hh"
#include "TH2F.h"

namespace SpartyJet { 

  class JetHistoryView : public  PtMarker , public HistoryProvider<JetHistoryView> {
  public:
    //HistoryNode<JetHistoryView> hnode;
    
    JetHistoryView() {};
    ~JetHistoryView(){// std::cout << "JetHistoryView dying at " << this << std::endl;
    };
  

    void drawConstituents(int color=kGray, int style=6, float size=1);

    void setConstitutentStyle(int style);
    void setConstitutentColor(int color);
    void setConstitutentSize(float size);
    void setConstitutentAtt(TAttMarker &m);

    void drawParent(int color=kGray, int style=6, float size=1);

    void drawJet(int color=kGray, int style=6, float size=1){Draw(color,style,size);};
    void drawJet(TAttMarker &m){Draw(m);}
    


    void init(HistoryElement &el);
    void buildJet();

    void debug();
  protected:

	ClassDef(JetHistoryView,0);
  };
  


  class JetHistViewCollection {
  public:
    JetHistViewCollection(){};
    JetHistViewCollection(JetCollection &jcoll);

    void drawConstituents(bool onlyFinalJet=false);

    size_t size(){return m_hview.size();}
    JetHistoryView* at(int i){return &m_hview[i];}
    JetHistoryView* operator[](int i){return &m_hview[i];}

    size_t finalSize(){return m_finaljet_hview.size();}
    JetHistoryView* finalJet(int i){return m_finaljet_hview[i];}

    
    std::vector<JetHistoryView*> historyNoConstituent();

  protected:
    std::vector<JetHistoryView> m_hview;
    std::vector<JetHistoryView*> m_finaljet_hview;
    std::vector<JetHistoryView> m_singleconstit_hview;

  };

}
#endif
