#ifndef _JETRETRIEVERFILE_H
#define _JETRETRIEVERFILE_H


#include <vector>
#include <string>


#include "JetInputCollection.hh"
#include "JetCollReaderBase.hh"

#include <TFile.h>
#include <TTree.h>

const int MAXJETS  = 300;
const int MAXALGS  = 100;
const int MAXINPUT = 10000;
namespace SpartyJet { 

class JetCollExtended;


class JetRetrieverFile {
public:
  JetRetrieverFile();

  void fill_collections(JetInputCollection & jet_input_coll, vector<SpartyJet::JetCollExtended > & jet_coll_v,int event);

  void get_collection(JetInputCollection & jet_input_coll, JetCollExtended & jcoll , int numC ,int event);

  void fill_inputColl(JetInputCollection & inputColl,int event);


  void init(string treename, string filename, int input_type=0);
  void set_tree_file(string treename, string filename, int input_type=0);



  /// retrieve jet algorithm variables in the current tree. Fill the m_names array
  void retrieve_algs();
  /// Retrieve the jet moment variables for algorithm alg_name
  vector<string> get_alg_moments(string alg_name);
  

  
  //vector<string> getAlgNames() {return m_names;}
  vector<string> getAlgNames() ;
  size_t get_num_algs(){return m_jetreaders.size();}

  string get_alg_name(int i){ return m_jetreaders[i]->name();}
  int get_numevents() {return m_nEvents;}

  void set_input_name();
  void set_input_name(string n){m_input_name=n;}
  void set_input_isGeV(bool isGeV){m_input_isGeV=isGeV;}
  bool get_input_isGeV(){return m_input_isGeV;}
  void set_inputvar_names(string v1,string v2,string v3,string v4) 	{m_input_v1=v1;m_input_v2=v2;m_input_v3=v3;m_input_v4=v4;}
  void set_jetvar_names(string v1,string v2,string v3,string v4) 		{m_jet_v1=v1;m_jet_v2=v2;m_jet_v3=v3;m_jet_v4=v4;}

  std::vector<SpartyJet::IJetCollReader*> get_jetreaders(){return m_jetreaders;}
  IJetCollReader  * get_inpureader(){return m_inputreader;}

  TTree * get_tree(){return m_tree;}

  int test_first_event();


  void add_jetcoll_reader(string name, bool alsosetname=false);
  int get_current_event(){return m_currentEvent;}
  
protected:
  std::vector<IJetCollReader*> m_jetreaders;
  IJetCollReader  *m_inputreader;

  void init_inputReader(IJetCollReader *reader);


  string m_treename;
  string m_filename;
  int m_nAlgs;

  int m_input_type;

  TFile* m_file;
  TTree* m_tree;
  int m_nEvents;
  vector<string> m_names;
  string m_input_name;
	bool m_input_isGeV;
	string m_input_v1,m_input_v2,m_input_v3,m_input_v4;
	string m_jet_v1,m_jet_v2,m_jet_v3,m_jet_v4;

  int m_currentEvent;
};
}  // namespace SpartyJet
#endif
