import ROOT
_v = ROOT.TLorentzVector()

ROOT.gSystem.Load("../libs/libJetCore.so")
ROOT.gSystem.Load("../libs/libSpartyDisplay.so")

from ROOT import SpartyJet as SJ

class PyJetRetrieverFile(SJ.JetRetrieverFile):
    def __init__(self):
        SJ.JetRetrieverFile.__init__(self)



    def find_algs(self,inputname, alias=""):
        t = self.get_tree()
        if alias != '':
            alias = alias+'.'
        names = set()
        for  b in t.GetListOfBranches( ) :
            s = b.GetName()
            names.add(alias+s[:s.find( '_')] )
        names = list(names - set([inputname]))
        names.sort()
        print 'Found algs ', names
        for n in names:
            self.add_jetcoll_reader(n,True)
        self.names = names
        return names

    def fill_collection(self, jc_item, event):
        numc = self.names.index(jc_item.name)
        self.get_collection(jc_item.inputcoll, jc_item.jetcoll , numc, event)
        
            
        
