import os
_sparty_lib = os.environ.setdefault('SPARTYJETLIBS','../libs/')

import ROOT


from JetRetrieverFile import PyJetRetrieverFile
import JetRetrieverLive
import JetHistoryGui

#from collections import namedtuple
ROOT.gSystem.Load(os.path.join(_sparty_lib, "libJetCore.so") )

EventViewBase = ROOT.SpartyJet.EventViewBase

class JetCollItems(object):
    retriever = None
    button = None
    def __init__(self,name, r=None, b=None ):
        self.name = name
        self.retriever = r
        self.button  = b
        self.jetcoll = None
        self.inputcoll = None
        self.input_retriever = None

    def add_input_retriever(self, ret):
        self.input_retriever = ret

    def __str__(self):
        return "JetCollection %s (jetcoll= %s, retriever=%s, input_retriever=%s) "%(self.name, self.jetcoll, self.retriever, self.input_retriever)

    def show(self):
        print 'JetCollection ',self.name
        print '              jetcoll   =',self.jetcoll
        print '              inputcoll =',self.inputcoll
        print '              retriever =',self.retriever
        print '              input_retriever =',self.input_retriever

class ViewerItem(object):
    def __init__(self, view=None, b=None):
        self.button  = b
        self.viewer = view
        # guess a name from the viewer class str (someting like <ROOT.SpartyJet::Event2DView object at 0x99515b8>)
        s = str(view)
        self.name = s[ s.find('::')+2 : s.find(' o')]

class SpartyGui(ROOT.TGMainFrame) :

    def __init__(self, p, ):
        ROOT.TGMainFrame.__init__(self,p,1000,800)
        #print 'LArGui : thread = ', thread.get_ident(), 'self= ',self
        self.currentEvent = 0

        self.names = ["bla", 'blu','bli', 'ble', 'blo']


        self.runPlotRadioButtons = []
        self.algSelectCheckButtons = []
        self.jobSelectCheckButtons = []

        self.dispatchers = []

        self.JetCollections = {}
        self.JetCollectionsLive = {}

        self.viewer_items = []

        self.inputJetItem = []

    def init(self):
        
        self.canvas =  ROOT.TCanvas("SpartyCanvas")
        p = self.canvas.cd()
        #self.drawer.set_pad(p)
        self.current_subpad = 0
        self.ndivX = 1
        self.ndivY = 1


        kVerticalFrame, kHorizontalFrame = ROOT.kVerticalFrame,ROOT.kHorizontalFrame
        kLHintsLeft , kLHintsTop = ROOT.kLHintsLeft , ROOT.kLHintsTop
        kLHintsExpandX, kLHintsExpandY = ROOT.kLHintsExpandX, ROOT.kLHintsExpandY

        vert_layout =  ROOT.TGVerticalLayout( self)
        self.SetLayoutManager(vert_layout)

        self.fLayout =    ROOT.TGLayoutHints()

        # First group for canvas manipulation ************************************************
        #canvas_group =  ROOT.TGGroupFrame(self,"canvas_group",kHorizontalFrame,ROOT.TGGroupFrame.GetDefaultGC()(),ROOT.TGGroupFrame.GetDefaultFontStruct())
        topcanvas_group =  ROOT.TGGroupFrame(self,"canvas_group",kHorizontalFrame,ROOT.TGGroupFrame.GetDefaultGC()(),ROOT.TGGroupFrame.GetDefaultFontStruct())
        canvas_group =  ROOT.TGCompositeFrame(self,kHorizontalFrame,ROOT.TGGroupFrame.GetDefaultGC()(),ROOT.TGGroupFrame.GetDefaultFontStruct())
        
        canvas_group.AddFrame( ROOT.TGLabel(canvas_group, "num cols"),self.fLayout)
        canvas_group.AddFrame( ROOT.TGLabel(canvas_group, "num rows"),self.fLayout)


        self.ndivx_entry =  ROOT.TGNumberEntry(canvas_group, 1,6, 991199, 0,2)
        canvas_group.AddFrame(self.ndivx_entry,  ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop,2,2,2,2))
        self.connect_dispatcher(self.ndivx_entry, "ValueSet(Long_t)", self.clear_canvas)


        self.ndivy_entry =  ROOT.TGNumberEntry(canvas_group, 1.0,6,991199,0,2)
        canvas_group.AddFrame(self.ndivy_entry,  ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop,2,2,2,2))
        self.connect_dispatcher(self.ndivy_entry, "ValueSet(Long_t)", self.clear_canvas)


        c_reset_button =  ROOT.TGTextButton(canvas_group,"Reset",991199)
        canvas_group.AddFrame(c_reset_button,  ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop,2,2,2,2))
        #c_reset_button.Connect("Clicked()","TGTextButton",self.canvas, "Clear()") 
        self.connect_dispatcher(c_reset_button, "Clicked()", self.reset_canvas)

        c_clear_button =  ROOT.TGTextButton(canvas_group,"Clear",991199)
        canvas_group.AddFrame(c_clear_button,  ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop,2,2,2,2))
        #c_clear_button.Connect("Clicked()","TGTextButton",self.canvas, "Clear()") 
        self.connect_dispatcher(c_clear_button, "Clicked()", self.clear_canvas)

        canvas_group.SetLayoutManager( ROOT.TGMatrixLayout(canvas_group,0,2,2,0))

        topcanvas_group.AddFrame(canvas_group,  ROOT.TGLayoutHints(kLHintsLeft |kLHintsTop | kLHintsExpandX ))

        topcanvas_group.AddFrame(ROOT.TGIcon( topcanvas_group,"../display/block-S.gif"),ROOT.TGLayoutHints(kLHintsLeft) )
        self.AddFrame(topcanvas_group,  ROOT.TGLayoutHints(kLHintsLeft |kLHintsTop | kLHintsExpandX ))

        # end canvas manipulation ************************************************



        jetcoll_group =  ROOT.TGGroupFrame(self,"JetCollections",kVerticalFrame,ROOT.TGGroupFrame.GetDefaultGC()(),ROOT.TGGroupFrame.GetDefaultFontStruct())

        NCollumn = 4
        jetcoll_group.SetLayoutManager( ROOT.TGMatrixLayout(jetcoll_group,0,NCollumn))


        # ###############/
        # Check buttons for algorithms
        # ###############/
        names = self.names

        
        for jc, jetitems in self.JetCollections.iteritems():
            button = self.add_check_button(jetcoll_group,jc, 991199, JetCollCheckButton())
            jetitems.button = button
            pass

        # for a1 in range(len(names)):
        #     id2 = 991199+a1
        #     self.add_check_button(jetcoll_group,names[a1], id2, self.algSelectCheckButtons)

        ncomplete =(NCollumn -  len(self.JetCollections)%NCollumn) % NCollumn # complete to a multiple of NCollumn
        for a in range(ncomplete):
            # just fill with void frame
            jetcoll_group.AddFrame( ROOT.TGFrame(jetcoll_group),self.fLayout)


        self.AddFrame(jetcoll_group,  ROOT.TGLayoutHints(kLHintsLeft |kLHintsTop | kLHintsExpandX ))

        # end jetcoll manipulation ************************************************

        # A horizontal frame 
        hframe =  ROOT.TGHorizontalFrame(self) 
        
        # define groups for event by event operations
        event_plots_group =  ROOT.TGGroupFrame(hframe,"Event by Event plots")
        hframe.AddFrame(event_plots_group,  ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop | kLHintsExpandY| kLHintsExpandX))

        # define groups for run operations
        run_plots_group =  ROOT.TGGroupFrame(hframe,"Run plots")
        hframe.AddFrame(run_plots_group,  ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop | kLHintsExpandY| kLHintsExpandX))
        
        self.AddFrame(hframe,  ROOT.TGLayoutHints(  kLHintsLeft |kLHintsTop | kLHintsExpandX | kLHintsExpandY  ))
        
        # All event operations ********************************************************
        evbyev_frame =  ROOT.TGVerticalFrame(event_plots_group)
        evbyev_frame.SetLayoutManager( ROOT.TGMatrixLayout(evbyev_frame,0,3))
        event_plots_group.AddFrame(evbyev_frame, ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop | kLHintsExpandX))


        self.PreviousEventButton =  ROOT.TGTextButton(evbyev_frame,"Previous Event",991199)
        #self.PreviousEventButton.Associate(self)
        evbyev_frame.AddFrame(self.PreviousEventButton,self.fLayout)



        self.EventNumEntry =  ROOT.TGNumberEntry(evbyev_frame,self.currentEvent,10,991199,ROOT.TGNumberFormat.kNESInteger,ROOT.TGNumberFormat.kNEANonNegative)
        self.EventNumEntry.Associate(self)
        evbyev_frame.AddFrame(self.EventNumEntry,self.fLayout)


        self.NextEventButton =  ROOT.TGTextButton(evbyev_frame,"Next Event",991199)
        self.NextEventButton.Associate(self)
        evbyev_frame.AddFrame(self.NextEventButton,self.fLayout)


        self.connect_dispatcher(self.EventNumEntry, "ValueSet(Long_t)", self.draw_current_event)
        self.NextEventButton.Connect("Clicked()","TGNumberEntry", self.EventNumEntry, "IncreaseNumber()")
        self.PreviousEventButton.Connect("Clicked()","TGNumberEntry", self.EventNumEntry, "IncreaseNumber(=0,-1,false)")
        self.connect_dispatcher(self.NextEventButton, "Clicked()", self.draw_current_event)
        self.connect_dispatcher(self.PreviousEventButton, "Clicked()", self.draw_current_event)



        self.viewer_items = [
            ViewerItem(ROOT.SpartyJet.LegoView()) ,
            ViewerItem(ROOT.SpartyJet.Event2DView()) ,
            ViewerItem(ROOT.SpartyJet.SnowMassView()) ,
            ViewerItem(ROOT.SpartyJet.ParamSpace()) ,
            ViewerItem(ROOT.SpartyJet.PrintEvent()) ,
            ]
        for vit in self.viewer_items :
            vit.button = self.add_check_button(event_plots_group, vit.viewer.title() , 991199, SJCallBack())
            setattr( self ,vit.name , vit.viewer) # this creates shortcuts to the viewer classes

        self.perform_evbyev_b =  ROOT.TGTextButton(event_plots_group,"Draw",991199)
        self.connect_dispatcher(self.perform_evbyev_b, "Clicked()", self.draw_current_event)
        event_plots_group.AddFrame(self.perform_evbyev_b,self.fLayout)

        evbyev_options =  ROOT.TGTextButton(event_plots_group,"Options",991199)
        evbyev_options.Associate(self)
        event_plots_group.AddFrame(evbyev_options,self.fLayout)

        history_button = ROOT.TGTextButton(event_plots_group,"View History",991199)
        event_plots_group.AddFrame(history_button,self.fLayout)
        self.connect_dispatcher(history_button, "Clicked()", self.view_history)
        
        # on the fly algorithms ---------------------------------

        expandx_layout = ROOT.TGLayoutHints(kLHintsLeft | kLHintsTop | kLHintsExpandX)
        onthefly_group =  ROOT.TGGroupFrame(hframe,"On the fly algorithms")
        event_plots_group.AddFrame(onthefly_group , expandx_layout)
        
        onthefly_combo = ROOT.TGComboBox(onthefly_group,'Algo type')
        for i,a in enumerate(JetRetrieverLive.defined_algs):
            onthefly_combo.AddEntry(a.name,i)
        onthefly_combo.SetHeight(20)
        onthefly_combo.SetEditable(False)

        self.onthefly_combo = onthefly_combo
        onthefly_group.AddFrame(onthefly_combo,expandx_layout)

        otf_hframe = ROOT.TGHorizontalFrame(onthefly_group)
        onthefly_group.AddFrame(otf_hframe,expandx_layout)
        
        self.otf_txtentry =[]

        for i in range(3):
            entry = ROOT.TGTextEntry(otf_hframe,"")
            otf_hframe.AddFrame(entry, expandx_layout)
            self.otf_txtentry.append(entry)
        self.otf_txtentry[0].SetText("0.5")

        otf_lab="main param"
        for i in range(3):
            otf_hframe.AddFrame(ROOT.TGLabel(otf_hframe, otf_lab), expandx_layout)
            otf_lab = "param "+str(i+1)

        otf_hframe.SetLayoutManager( ROOT.TGMatrixLayout(otf_hframe,0,3))

        onthefly_button = ROOT.TGTextButton(onthefly_group,"Create",991199)
        onthefly_group.AddFrame(onthefly_button,self.fLayout)




        otf_line = ROOT.TGHorizontal3DLine(onthefly_group)
        onthefly_group.AddFrame(otf_line,expandx_layout)

        self.onthefly_group = onthefly_group

        self.connect_dispatcher(onthefly_button, "Clicked()", self.add_onthefly_algorithm)
        # end event operations ********************************************************

        

        # full run operations ********************************************************

        run_vars_hframe = ROOT.TGHorizontalFrame(run_plots_group)
        run_plots_group.AddFrame(ROOT.TGLabel(run_plots_group, "Choose a variable to be drawn : ") , expandx_layout)
        run_plots_group.AddFrame(run_vars_hframe)
        self.run_vars_buttons = []
        self.run_defalt_vars = ['e','pt','eta','phi','mass']
        for vname in self.run_defalt_vars :
            self.run_vars_buttons +=[ self.add_check_button(run_vars_hframe, vname , 991199, SJCallBack())]

        run_plots_group.AddFrame(ROOT.TGHorizontal3DLine(run_plots_group), expandx_layout)
        run_plots_group.AddFrame(ROOT.TGLabel(run_plots_group, "... or give the expression to be draw below") , expandx_layout)
        run_plots_group.AddFrame(ROOT.TGLabel(run_plots_group, "(use $$ as a wildcard (ex: $$_p_T) to be replaced by checked jets") , expandx_layout)

        run_plots_group.AddFrame(ROOT.TGLabel(run_plots_group, "expression") , expandx_layout)
        self.run_expr_text = ROOT.TGTextEntry(run_plots_group,"")
        run_plots_group.AddFrame(self.run_expr_text, expandx_layout)

        run_plots_group.AddFrame(ROOT.TGLabel(run_plots_group, "cuts") , expandx_layout)
        self.run_sel_text = ROOT.TGTextEntry(run_plots_group,"")
        run_plots_group.AddFrame(self.run_sel_text, expandx_layout)


        run_options_hframe = ROOT.TGHorizontalFrame(run_plots_group)
        run_options_hframe.SetLayoutManager( ROOT.TGMatrixLayout(run_options_hframe,0,2))

        run_plots_drawbutton = ROOT.TGTextButton(run_options_hframe,"Draw",991199)
        run_options_hframe.AddFrame(run_plots_drawbutton,self.fLayout)
        self.connect_dispatcher(run_plots_drawbutton, "Clicked()", self.draw_run_plots)        
        
        run_plots_resetbutton = ROOT.TGTextButton(run_options_hframe,"reset",991199)
        run_options_hframe.AddFrame(run_plots_resetbutton,self.fLayout)
        self.connect_dispatcher(run_plots_resetbutton, "Clicked()", self.reset_run_plots)        

        run_plots_group.AddFrame(run_options_hframe, expandx_layout)



        # load_event(self.currentEvent)

        self.MapSubwindows()

        self.Layout()

        self.SetWindowName("SpartyJet Analysis Tool")
        self.SetIconName("SpartyJet Analysis Tool")

        self.MapWindow()

    def draw_current_event(self, *l):
        print "draw_current_event",l
        evt = self.EventNumEntry.GetIntNumber()
        active_jets = [ ji for ji in self.JetCollections.values()+self.JetCollectionsLive.values() if ji.button.IsOn() ]
        active_views = [ ji for ji in self.viewer_items if ji.button.IsOn() ]
        print active_views
        p = 1
        for ji in active_jets:
            ji.show()
            #print ' Drawing ', ji            
            for vi in active_views:
                if evt != ji.retriever.get_current_event():
                    vi.viewer.clear_graphic_objects()
                ji.retriever.fill_collection(ji,evt)
                pad = self.canvas.cd(p)
                EventViewBase.setPad(pad)
                vi.viewer.draw_jets(ji.jetcoll, ji.inputcoll, ji.name, ji.name )
                p = p+vi.viewer.num_pad_used()
        #for i,jitem in enumerate(self.JetCollections):
            
        pass

    def reset_canvas(self, *l):
        self.canvas.Clear()
        self.canvas.Update()
        self.ndivy_entry.SetIntNumber(1)
        self.ndivx_entry.SetIntNumber(1)

    def clear_canvas(self,*l):
        c1= self.canvas
        c1.Clear()
        nx , ny = self.ndivx_entry.GetIntNumber() ,self.ndivy_entry.GetIntNumber()
        c1.Divide(nx,ny)
        c1.cd(1)
        c1.Update()

    def connect_dispatcher(self, element, signal, callback, *args):
        """ callback_class is expected to be inheriting SJCallBack"""
        if isinstance(callback , SJCallBack):
            callback.gui = self
            callback.element = element
        disp = ROOT.TPyDispatcher( callback )
        self.dispatchers.append(disp)
        element.Connect(signal, "TPyDispatcher", disp, "Dispatch()")
        



  #  Helper function to correctly set-up and associate check-buttons
    def add_check_button(self, container_frame,  button_name,  id, callback):

        button      = ROOT.TGCheckButton(container_frame,button_name,id );  
        #button.Associate(self)  
        container_frame.AddFrame(button, self.fLayout)

        self.connect_dispatcher( button , "Clicked()" , callback)
        return button


    def add_radio_button(self, container_frame,  button_name, id):

        button      =  TGRadioButton(container_frame,button_name,id )  
        button.Associate(this)  
        container_frame.AddFrame(button, self.fLayout)
        
        self.runPlotRadioButtons.push_back(button)

        
    def add_text_button(self,container_frame, button_name,  id, button_vect):

        button      =  TGTextButton(container_frame,button_name,id )  
        button.Associate(this)  
        container_frame.AddFrame(button, self.fLayout)

        if button_vect : button_vect.push_back(button)
        return button


        
    def add_onthefly_algorithm(self):
        ialg = self.onthefly_combo.GetSelected()
        params = [ self.otf_txtentry[i].GetText() for i in range(3) ]
        print "ialg =",ialg,"  main p=",params
        jettool = JetRetrieverLive.defined_algs[ialg](float(params[0]) ,*params[1:])
        jretrieve = JetRetrieverLive.PyJetRetrieverLive(jettool)
        jbutton = self.add_check_button(self.onthefly_group, jettool.name() , 991199, SJCallBack())
        jcitem = JetCollItems(jettool.name() , jretrieve , jbutton)
        jcitem.inputcoll = self.inputJetItem[0].inputcoll
        jcitem.jetcoll   = ROOT.SpartyJet.JetCollExtended()
        jcitem.add_input_retriever(self.inputJetItem[0].retriever)

        jbutton.MapWindow()
        #self.MapSubwindows()        
        #self.MapWindow()
        self.Layout()
        self.onthefly_group.AddFrame(jbutton)
        self.JetCollectionsLive[jettool.name()]=jcitem


    def view_history(self):
        evt = self.EventNumEntry.GetIntNumber()
        active_jets = [ ji for ji in self.JetCollectionsLive.values() if ji.button.IsOn() ]
        try :
            jetitem = active_jets[0]
        except:
            print "No live jets " , active_jets 
            return
        if not jetitem.jetcoll.has_history():
            print 'no history for jets ',jetitem.name
            return
        print 'History for jets ',jetitem.name
        j=JetHistoryGui.JetHistoryGui(ROOT.gClient.GetRoot(),self,jetitem)
        j.init()
        self.historyV = j
        self.canvas.cd()
        pass

  
    def draw_ev_all_jobs():
        self.fill_selected_jobs();
        self.fill_selected_algs();

        npad = self.ndivY * self.ndivX
  
        count=0

    def reset_run_plots(self):
        self.run_expr_text.SetText("")
        self.run_sel_text.SetText("")

    def draw_run_plots(self):
        print 'draw_run_plots'
        self.run_histos = []
        active_jets = [ ji for ji in self.JetCollections.values()+self.JetCollectionsLive.values() if ji.button.IsOn() ]
        toDraw = self.run_expr_text.GetText()
        if toDraw =="" :            
            try:
                ind = [b.IsOn() for b in self.run_vars_buttons].index(True)
                toDraw = "$$_"+self.run_defalt_vars[ind]
            except:
                pass
        if toDraw=="": return
        toSelec = self.run_sel_text.GetText()
        
        for ji in active_jets:
            expr = toDraw.replace('$$',ji.name)
            sel = toSelec.replace('$$',ji.name)
            tree = ji.retriever.get_tree()
            tree.Draw(expr,sel," goff")  
            h = ROOT.TH1F( tree.GetHistogram() )
            h.SetName(ji.name)
            h.SetTitle(toDraw.replace('$$','Jet') )
            self.run_histos.append( h)
        colors=[ROOT.kBlack, ROOT.ROOT.kRed, ROOT.kBlue, ROOT.kGreen, ROOT.kYellow, ROOT.kMagenta,ROOT.kCyan, ROOT.kOrange ]
        s=''
        leg = ROOT.TLegend(0.6 , 0.6, 0.9, 0.9)
        for c,h in zip(colors,self.run_histos):
            h.SetLineColor(c)
            leg.AddEntry(h,h.GetName())
            h.Draw(s)
            s='same'
        leg.Draw()
        self.run_histos.append(leg)
        self.canvas.Update()



    def setLiveAlgFinalCut(self,cut):
        JetRetrieverLive.PyJetRetrieverLive.setFinalCut(cut)

    def IsOptionsOpen():
        return self.OptionsOpen
  
    def SetOptionsOpen(b):
        self.OptionsOpen = x
      
    def viewersOption_use_rapidity(self, b):
        for v in self.viewer_items:
            v.viewer.option_use_rapidity = b
    def viewersOption_min_pt_display(self, pt):
        for v in self.viewer_items:
            v.viewer.option_min_pt_jet_display = pt


    def addTree(self, tree, filename , inputname="InputJet" ,alias="" ):
        ''' treename can be a TTree or a string (then filename must be set)'''
        ret = PyJetRetrieverFile()
        ret.set_tree_file(tree,filename,5)
        ret.set_input_name(inputname)
        names = ret.find_algs(inputname,alias)
        jetsItems = {}
        for n in names :
            ji = JetCollItems(n , ret)
            ji.jetcoll = ROOT.SpartyJet.JetCollExtended()
            jetsItems[n] = ji                

        inputJetItem = JetCollItems(n , ret)
        inputJetItem.inputcoll = ROOT.SpartyJet.JetInputCollection()
        for ji in jetsItems.values():
            ji.inputcoll = inputJetItem.inputcoll
        self.JetCollections.update(jetsItems)
        self.inputJetItem.append(inputJetItem)

# public:


#   enum SpartyMessage {
#     MSG_EXIT =0,
#     MSG_NEXT_EVENT,
#     MSG_PREV_EVENT,
#     MSG_SET_EVENT,
#     MSG_CANVAS_RESET,
#     MSG_CANVAS_CLEAR,
#     MSG_CANVAS_DIVX,
#     MSG_CANVAS_DIVY,

#     MSG_ALGO_CHECKBUTTON=2000,


#     #  event plots button 
#     MSG_EV_CHECKB_FIRST = 3000,
#     MSG_EV_CHECKB_PRINTEV   ,
#     MSG_EV_CHECKB_SNOWMASS  ,
#     MSG_EV_CHECKB_DVSZPLOT  ,
#     MSG_EV_CHECKB_LEGOPLOT  ,
#     MSG_EV_CHECKB_2DVIEW    ,
#     MSG_EV_CHECKB_LAST,

#     MSG_BUTTON_DRAW_EV,
#     MSG_BUTTON_OPTIONS,

#     MSG_ALGO_CHECKBUTTON_R= 4000,
    
#     #  Run plots button 
#     MSG_RUN_CHECKB_FIRST =5000,
#     MSG_RUN_CHECKB_ETPLOT,
#     MSG_RUN_CHECKB_MASSPLOT,
#     MSG_RUN_CHECKB_PHIPLOT,
#     MSG_RUN_CHECKB_ETAPLOT,
#     MSG_RUN_CHECKB_PTPLOTA,
#     MSG_RUN_CHECKB_LAST,

#     MSG_BUTTON_DRAW_RUN,
#     MSG_RUN_FIRST_ENTRY,
#     MSG_RUN_LAST_ENTRY,
    
#     MSG_RUN_EXP_ENTRY,
#     MSG_RUN_SEL_ENTRY,

#     MSG_RUN_MIN,
#     MSG_RUN_MAX,
#     MSG_RUN_NBIN,

#     MSG_ONTHEFLY_ADD,

#     MSG_RUN_RADIOBUTTON = 9000,
		
#   }
		


class SJCallBack(object):
    def __init__(self, gui=None, element=None):
        self.gui = gui
        self.element = element

    def __call__(self, *l):
        if self.element.IsOn():
            print self.element, 'on'
        else:
            print self.element, 'off'


class JetCollCheckButton(SJCallBack):
    pass


