#ifndef _EVENTSHAPE_HH_
#define _EVENTSHAPE_HH_

#include "JetTools/JetSelectorTool.hh"
#include "JetCore/JetAlgorithm.hh"
/////////////////////////////////////////////////////////////////////////
/// \class ShapeConfig
/// A convenience class to configure event shape calculation
///
/// This is just an easy way of configuring a JetAlgorithm that will compute
/// event shapes. One gives ShapeConfig some JetTool that compute some global 
/// moments, then ShapeConfig returns a properly configured JetAlgorithm.
/// For example :
///
///   eventshape::ShapeConfig shape;
///   eventshape::ThrustTool tt("Thrust");
///   shape.add_eventshape(&tt);
///   builder.add_eventshape_alg(shape.get_algo());
///
/// where builder is a JetBuilder instance. 
/////////////////////////////////////////////////////////////////////////
namespace SpartyJet { 

namespace eventshape {

  enum shape_type {

    // official spartyjet eventshape
    THRUST = 1,
    THRUST_PHI,
    THRUST_MINOR,
    
    // Reserve for user
    USER_DEFINED = 1000,

    //
    UNKNOWN = 10000
  };
  
  
  class ShapeConfig {
  public:
    ShapeConfig(std::string name="EventShape");
    
    
    void set_eta_range(double etamin, double etamax){m_etaSelec.setCut(etamax);m_etaSelec.setCut2(etamin);}
    void set_pt_cut(double ptmin){ m_ptSelec.setCut(ptmin);}
    
    void add_eventshape(shape_type type);
    void add_eventshape(JetTool *tool);
    
    JetAlgorithm * get_algo(){return &m_thealg;};
  protected:
    std::string m_name;
    JetEtaCentralSelectorTool m_etaSelec;
    JetPtSelectorTool m_ptSelec;
    
    JetAlgorithm  m_thealg;
    
    //std::list<JetTool*> m_owned_tool;
    
  };

};



}  // namespace SpartyJet
#endif
