#ifndef _THRUST_TOOL_HH_
#define _THRUST_TOOL_HH_

#include <string>
#include "JetCore/Jet.hh"
#include "JetCore/JetTool.hh"
#include "JetCore/JetCollection.hh"
//#include "Vector/ThreeVector.h"
#include "TVector3.h"
namespace SpartyJet { 

class JetMomentMap;



namespace eventshape {

  class ThrustTool : public JetTool {
  public:

    typedef JetCollection::const_iterator jetIt_t;

    ThrustTool(std::string name) : JetTool(name){};
    virtual void init(JetMomentMap *mmap) ;
    virtual void execute(JetCollection &inputJets) ;
    

    
    TVector3 thrust( const JetCollection * theParticles,
		       double& thrust_major, double& thrust_minor, bool useThreeD=false);
    
    TVector3 thrust( const jetIt_t iBeg, const jetIt_t iEnd,
		       double& thrust_major, double& thrust_minor, bool useThreeD=false);
    
  };

};
}  // namespace SpartyJet
#endif 
