#include "JetCore/JetBuilder.hh"
#include "JetCore/StdTextInput.hh"
#include "fastjet/FastJetFinder.hh"

#include "fastjet/JetDefinition.hh" // note that all of the FastJet object code
#include "fastjet/SISConePlugin.hh" // is included in libFastJet.so

using namespace fastjet;

using namespace SpartyJet;
using namespace SpartyJet::FastJet;

int main(){

  // Create a builder object
  JetBuilder builder;
  builder.silent_mode(); // turn off debugging

  // Create an input object and open the input file
  StdTextInput textinput("../data/J1_Clusters.dat");
  builder.configure_input((InputMaker*)&textinput);

  // Add an algorithm (AntiKt)
  FastJetFinder *anti4 = new FastJetFinder("AntiKt4",antikt_algorithm,0.4,false);
  builder.add_default_alg(anti4);

  // Same algorithm, uses your own JetDefinition
  JetDefinition jet_def(antikt_algorithm, 0.4);
  FastJetFinder *anti4_2 = new FastJetFinder(&jet_def,"AntiKt4_2",false);
  builder.add_default_alg(anti4_2);

  // More interesting example: FastJet Plugin
  // Note that SISCone is included in FastJet, but is implemented as a plugin
  // To use your own plugin, you will need to link against the relevant library
  double coneRadius = 0.4, overlapThreshold = 0.75;
  SISConePlugin plugin(coneRadius,overlapThreshold);
  JetDefinition plugin_jet_def(&plugin);
  FastJetFinder *siscone4 = new FastJetFinder(&plugin_jet_def,"SISCone4",false);
  builder.add_default_alg(siscone4);


  // Add a text output file to easily list all of the jets
  builder.add_text_output("../data/output/simple.dat");

  // Configure the output (name of tree, root file)
  builder.configure_output("SpartyJet_Tree","../data/output/simple.root");

  // Run the builder on the first 10 events
  builder.process_events(10);

  return 0;
}
