#include "TFile.h"
#include "TTree.h"

#include "JetCore/GetJets.hh"
#include "JetCore/Jet.hh"
#include "cdf/JetClustFinder.hh"
#include "JetCore/StdTextInput.hh"
#include <iostream>

using namespace SpartyJet ;

int main(){
  JetCollection inputJets;
  JetCollection outputJets;
    
	// Set up input
  StdTextInput textinput("../data/J1_Clusters.dat");
	
	// Configure Jet Finding tools
	SpartyJetTool sparty;
 	cdf::JetClustFinder* JetCluTool = new cdf::JetClustFinder("myJetClu");

  // Load individual events
	unsigned int ev = 0;
	while(textinput.fillNextInput(inputJets))
	{
		cout << "Event " << ev << ": got input from data file, " << inputJets.size() << " particles found \n";

		cout << "input particles" << endl;
		cout << "# : px py pz E\n";
		Jet *tjet;
		for(unsigned i = 0; i < inputJets.size(); i++) {
			tjet = inputJets[i];
			cout << tjet->index() << "   " 
				<< tjet->px() << "   " 
				<< tjet->py() << "   "
				<< tjet->pz() << "   "
				<< tjet->E() << endl;
		}

		// Run jet finding on that event
		outputJets = sparty.getjets((JetTool*)JetCluTool,inputJets);

		JetCollection::iterator iter  = outputJets.begin();
		JetCollection::iterator itE   = outputJets.end();

		cout << "output jets" << endl;
		cout << "# : pt Et eta phi\n";
		for( ; iter != itE; iter++) {
			tjet = *iter;
			cout << "------------------------------------------" << endl;
			cout << "JET index " << tjet->index() << ", "  
				<< tjet->px()   << ", " 
				<< tjet->py()   << ", " 
				<< tjet->pz()  << ", " 
				<< tjet->E()  << ", " << endl;
			cout << "------------------------------------------" << endl;
			cout << "constituents : " << tjet->getConstituentNum() << endl;

			Jet::constit_vect_t::iterator citer  = tjet->firstConstituent();
			Jet::constit_vect_t::iterator citE   = tjet->lastConstituent();
			Jet *cjet;
			for(; citer != citE; citer++) {
				cjet = *citer;
				cout << "index " << cjet->index() << ", "
					<< cjet->px()  << ", " 
					<< cjet->py()  << ", " 
					<< cjet->pz()  << ", " 
					<< cjet->E()   << endl;
			}
		} // end loop over output jets
		// Delete Jets before next event
		ev++;
		inputJets.clear_and_delete();
		outputJets.clear_and_delete();
  } // end loop over events
}
