#include "TFile.h"
#include "TTree.h"
#include "TLorentzVector.h"

#include "JetCore/GetJets.hh"
#include "cdf/JetClustFinder.hh"
#include "JetCore/StdTextInput.hh"
#include <iostream>
#include <vector>

using namespace SpartyJet ;

int main(){
  vector<TLorentzVector> inputJets;
  vector<TLorentzVector> outputJets;

	// Configure input
  JetCollection input;
  StdTextInput textinput("../data/J1_Clusters.dat");
	
	// Configure JetTool
	SpartyJetTool sparty;
  cdf::JetClustFinder* JetCluTool = new cdf::JetClustFinder("myJetClu");
  
	// Load individual events
	unsigned int ev = 0;
	while(textinput.fillNextInput(input))
	{
		cout << "Event " << ev << ": got input from data file, " << input.size() << " particles found \n";

		// Convert JetCollection to TLorentzVectors
		TLorentzVector* temp2;
		for(unsigned i = 0; i < input.size(); i++) {
			temp2 = new TLorentzVector(input[i]->px(),input[i]->py(),
					input[i]->pz(),input[i]->E());
			inputJets.push_back(*temp2);

			delete temp2;
		}

		cout << "input particles" << endl;
		TLorentzVector *tjet;
		for(unsigned i = 0; i < inputJets.size(); i++) {
			tjet = &inputJets[i];
			cout << i << " : " 
				<< tjet->Px() << "   " 
				<< tjet->Py() << "   "
				<< tjet->Pz() << "   "
				<< tjet->E() << endl;
		}

		vector<vector<int> > constituents;

		bool with_constituents = false;
		char response;
		std::cout << "do you want to include constituents? (y/n) : ";
		std::cin >> response;
		if(response == 'y') with_constituents = true;

		// Do jet finding
		if(with_constituents) {

			outputJets = sparty.getjets((JetTool*)JetCluTool,inputJets,constituents);

			if(constituents.size() != outputJets.size()) {
				cout << "ERROR WITH SIZES";
				exit(1);
			}

		}
		else {
			outputJets = sparty.getjets((JetTool*)JetCluTool,inputJets); 
		}

		cout << "output jets" << endl;
		for(unsigned i = 0; i < outputJets.size(); i++) {
			tjet = &outputJets[i];
			cout << "------------------------------------------" << endl;
			cout << i << " : " 
				<< tjet->Px() << ",  " 
				<< tjet->Py() << ",  "
				<< tjet->Pz() << ",  "
				<< tjet->E() << endl;
			cout << "------------------------------------------" << endl;

			if(with_constituents) {
				cout << "constituents : " << constituents[i].size() << endl;
				for(unsigned c = 0; c < constituents[i].size(); c++) {
					cout << "index " << constituents[i][c] << ", " 
						<< inputJets[constituents[i][c]].Px() << ",  " 
						<< inputJets[constituents[i][c]].Py() << ",  "
						<< inputJets[constituents[i][c]].Pz() << ",  "
						<< inputJets[constituents[i][c]].E() << endl;
				}
			}
		} // end loop over output jets
		ev++;
		inputJets.clear();
		outputJets.clear();
		input.clear_and_delete();
	} // end loop over events
}
