#include "TFile.h"
#include "TTree.h"
#include "TLorentzVector.h"

#include "JetCore/GetJets.hh"
#include "cdf/JetClustFinder.hh"
#include "JetCore/StdTextInput.hh"
#include <iostream>
#include <vector>

using namespace SpartyJet ;

int main(){
  vector<SpartyJet::simplejet> inputJets;
  vector<SpartyJet::simplejet> outputJets;

	// Configure input
  JetCollection input;
  StdTextInput textinput("../data/J1_Clusters.dat");
	
	// Configure JetTool
	SpartyJetTool sparty;
  cdf::JetClustFinder* JetCluTool = new cdf::JetClustFinder("myJetClu");
  
  // Load individual events
	unsigned int ev = 0;
	while(textinput.fillNextInput(input))
	{
		cout << "Event " << ev << ": got input from data file, " << input.size() << " particles found \n";

		// Convert JetCollection to simplejets
		TLorentzVector* temp2;
		SpartyJet::simplejet tempsimplejet;
		for(unsigned i = 0; i < input.size(); i++) {
			temp2 = new TLorentzVector(input[i]->px(),input[i]->py(),
					input[i]->pz(),input[i]->E());
			tempsimplejet.jet = *temp2;
			inputJets.push_back(tempsimplejet);
			delete temp2;
		}

		cout << "input particles" << endl;
		SpartyJet::simplejet *tjet;
		for(unsigned i = 0; i < inputJets.size(); i++) {
			tjet = &inputJets[i];
			cout << i << " : " 
				<< tjet->jet.Px() << "   " 
				<< tjet->jet.Py() << "   "
				<< tjet->jet.Pz() << "   "
				<< tjet->jet.E() << endl;
		}
		outputJets = sparty.getjets((JetTool*)JetCluTool,inputJets);

		cout << "output jets" << endl;
		for(unsigned i = 0; i < outputJets.size(); i++) {
			tjet = &outputJets[i];

			cout << "------------------------------------------" << endl;
			cout << i << " : " 
				<< tjet->jet.Px() << ",  " 
				<< tjet->jet.Py() << ",  "
				<< tjet->jet.Pz() << ",  "
				<< tjet->jet.E()  << endl;
			cout << "------------------------------------------" << endl;
			cout << "constituents : " << tjet->constituents.size() << endl;
			for(unsigned c = 0; c < tjet->constituents.size(); c++) {
				cout << tjet->constituents[c].Px() << ",  " 
					<< tjet->constituents[c].Py() << ",  "
					<< tjet->constituents[c].Pz() << ",  "
					<< tjet->constituents[c].E() << endl;
			}
		} // end loop over output jets
		ev++;
		inputJets.clear();
		outputJets.clear();
		input.clear_and_delete();
 	} // end loop over events 
}
