#include "JetCore/JetBuilder.hh"
#include "fastjet/FastJetFinder.hh"

// InputMaker includes
#include "JetCore/StdTextInput.hh"
#include "JetCore/InputMaker_Ntuple.hh"
#include "JetCore/CalchepPartonTextInput.hh"
#include "JetCore/StdHepInput.hh"
#include "JetCore/HepMCInput.hh"

using namespace fastjet;
using namespace SpartyJet;
using namespace SpartyJet::FastJet;

int main(){
  
	// Vector to store InputMaker instance of each input type
	std::vector<InputMaker*> inputs;

	// StdHep (if compiled with DO_STDHEP enabled, then this can be uncommented)
	//StdHepInput  stdHepInput("../data/ttbar_smallrun_pythia_events.hep");
	//nputs.push_back((InputMaker*)&stdHepInput);

	// Ntuple
  NtupleInputMaker ntupleInput(NtupleInputMaker::EtaPhiPtE_vector_float); // match to input
  ntupleInput.set_prefix("Cluster_");
  ntupleInput.set_suffix("");
  ntupleInput.set_n_name("N");
  ntupleInput.set_variables("eta","phi","pt","e");
  ntupleInput.setFileTree("../data/J2_clusters_wPile.root", "clusterTree");
  ntupleInput.set_name("NtupleInput");
	inputs.push_back((InputMaker*)&ntupleInput);

	// CalChep
	CalchepPartonTextInput calChepInput("../data/gg_ggg_events.dat");
	inputs.push_back((InputMaker*)&calChepInput);

	// HepMC
	HepMCInput hepMCInput("../data/HepMC_sample.dat");
	inputs.push_back((InputMaker*)&hepMCInput);
	
	std::vector<InputMaker*>::iterator inputItr = inputs.begin();
	bool updateOutput = false;
	for(;inputItr!=inputs.end();++inputItr)
	{
  	// Create a builder object
  	JetBuilder builder;
  	builder.set_message_level(WARNING);

		std::cout << "Now running on: " << (*inputItr)->name() << std::endl;
		builder.configure_input((*inputItr));

		// Add an algorithm (AntiKt)
		FastJetFinder *anti4 = new FastJetFinder("AntiKt4",antikt_algorithm,0.4);
		builder.add_default_alg(anti4);

		// Configure the output (name of tree, root file)
		builder.configure_output("SpartyJet_Tree","../data/output/simple.root",updateOutput);
		updateOutput=true; // after 1st iteration

		// Run the builder on the first 10 events
		builder.process_events(10);
	}

  return 0;
}
