#include "JetCore/JetBuilder.hh"
//#include "JetCore/StdTextInput.hh"
#include "JetCore/InputMaker_Ntuple.hh"
#include "cdf/JetClustFinder.hh"
#include "cdf/MidPointFinder.hh"
#include "celljet/CellJetFinder.hh"
#include "fastjet/FastJetFinder.hh"
#include "fastjet/SISConeFinder.hh"
#include "D0/D0RunIIConeFinder.hh"

using namespace fastjet;
using namespace SpartyJet;
using namespace SpartyJet::FastJet;


int main(){
	// Creat a JetBuilder 
  JetBuilder builder;
	builder.silent_mode(); // turn off debugging information

	// Configure Input
  //StdTextInput textinput("../data/J1_Clusters.dat");
  //textinput.set_name("FileInput");
	NtupleInputMaker input(NtupleInputMaker::EtaPhiPtE_vector_float); // match to input
	input.set_prefix("Cluster_");
	input.set_suffix("");
	input.set_masslessMode(false); 
	input.set_n_name("N");
	input.set_variables("eta","phi","pt","e");
	input.setFileTree("../data/J2_clusters_wPile.root", "clusterTree");
	input.set_name("Cluster");
  //builder.configure_input((InputMaker*)&textinput);
  builder.configure_input((InputMaker*)&input);
  
	// Schedule Algorithms to be run
	// algorithms can be added to the main JetBuilder with add_default alg()  
  // the second parameter in each of the add_default alg() calls is a boolean value that turns on constituents
  // the default is now true, so you only need to specify false in celljet (since constituents don't work)

	// Add a Midpoint alg
	cdf::MidPointFinder * tool1 = new cdf::MidPointFinder();  
  tool1->set_coneRadius(0.4);   // can set all parameters like this
  tool1->set_name("MidPoint4");
  builder.add_default_alg(tool1);
  
	// Add a Jet Clu alg
	builder.add_default_alg( new cdf::JetClustFinder("myJetClu"));
  
	// Add a CellJet alg
	builder.add_default_alg( new pythia::CellJetFinder("myCellJet"),false);
  
	// Add a Kt alg
  builder.add_default_alg(new FastJetFinder("Kt4",kt_algorithm,0.4));
  
	// Add a Cambridge-Aachen alg
  builder.add_default_alg(new FastJetFinder("CamAch4",cambridge_algorithm,0.4));
  
	// Add an AntiKt alg
  builder.add_default_alg(new FastJetFinder("AnitKt4",antikt_algorithm,0.4));
	
	// Add a SISCone alg
	builder.add_default_alg(new SISConeFinder("SISCone4",0.4));
  
	// Add D0's midpoint with second pass turned on
	//builder.add_default_alg( new D0::D0RunIIConeFinder("myD0Cone",true));

	//  Configure Output
	builder.configure_output("SpartyJet_Tree","../data/output/multi.root");
  builder.add_text_output("../data/output/multi.dat");
  
  // run
	builder.process_events(10);

 return 0;
}
