{
// ROOT libraries needed
gSystem->Load("libTree.so") ; // needed with recent ROOT version
gSystem->Load("libPhysics.so");
// Load the SpartyJet libraries that are needed
gSystem->Load("../libs/libJetCore.so");
gSystem->Load("../libs/libATLASJet.so");
gSystem->Load("../libs/libCDFJet.so"); 

using namespace SpartyJet;

//*************************************
//    Ntuple input
//*************************************
NtupleInputMaker input1(NtupleInputMaker::EtaPhiPtE_vector_float);
input1.set_prefix("Cluster_");
input1.set_suffix("");
input1.set_n_name("N");
input1.set_variables("eta","phi","pt","e");
input1.setFileTree("../data/J2_clusters_wPile.root","clusterTree");

JetBuilder builder1;
builder1.configure_input((InputMaker*)&input1);
builder1.add_default_alg( new cdf::JetClustFinder("myJetClu"));
builder1.add_text_output("../data/output/text_clusterinput.dat");
builder1.configure_output("Ntuple_Tree","../data/output/simple.root");

//*************************************
//    Calchep Parton Text input
//*************************************

CalchepPartonTextInput input2("../data/gg_ggg_events.dat");

JetBuilder builder2;
builder2.configure_input((InputMaker*)&input2);
builder2.add_default_alg( new cdf::JetClustFinder("myJetClu"));
//builder2.set_default_cut(0,1*input2.getGeV());
builder2.add_text_output("../data/output/text_calchep_test.dat");
builder2.configure_output("Calchep_Tree","../data/output/simple.root",true);

//*************************************
//    HepMC input
//*************************************

HepMCInput input3("../data/HepMC_sample.dat");

JetBuilder builder3;
builder3.configure_input((InputMaker*)&input3);
builder3.add_default_alg( new cdf::JetClustFinder("JetClu"));
builder3.add_text_output("../data/output/text_HepMCtest.dat");
builder3.configure_output("HepMC_Tree","../data/output/simple.root",true);

//*************************************
//    StdHEP input  (if StdHEP is included in compilation)
//*************************************

StdHepInput input4("../data/ttbar_smallrun_pythia_events.hep");
input4.set_name("StdHepInput");

JetBuilder builder4;
builder4.configure_input((InputMaker*)&input4);
builder4.add_default_alg( new cdf::JetClustFinder("JetClu"));
builder4.configure_output("StdHep_Tree","../data/output/simple.root",true); // true=> update output


builder1.process_events(10);
builder2.process_events(10);
builder3.process_events(10);
builder4.process_events(10);
}
