{
gSystem->Load("libTree.so") ; // needed with recent ROOT version
gSystem->Load("libPhysics.so");

gSystem->Load("../libs/libJetCore.so");
gSystem->Load("../libs/libCDFJet.so");
gSystem->Load("../libs/libCellJet.so");
gSystem->Load("../libs/libFastJet.so");
gSystem->Load("../libs/libD0Jet.so");

using namespace SpartyJet;
using namespace SpartyJet::FastJet;

StdTextInput textinput("../data/J1_Clusters.dat");
textinput.set_name("FileInput");

JetBuilder builder;
builder.configure_input((InputMaker*)&textinput);

cdf::MidPointFinder * tool1 = new cdf::MidPointFinder();  
tool1->set_coneRadius(0.4);   // can set all parameters like this
tool1->set_overlapThreshold(0.5);
tool1->set_name("MidPoint_withConeRadius_0.4");

// the second parameter in each of the "add_default alg() calls is a boolean value that turns on constituents
// the default is now true, so you only need to specify false in celljet (since constituents don't work)
builder.add_default_alg(tool1);
builder.add_default_alg( new cdf::JetClustFinder("myJetClu"));
builder.add_default_alg( new pythia::CellJetFinder("myCellJet"),false);
builder.add_default_alg( new FastJetFinder("AntiKt4",fastjet::antikt_algorithm,0.4));
builder.add_default_alg( new FastJetFinder("CambAach4",fastjet::cambridge_algorithm,0.4));
builder.add_default_alg( new FastJetFinder("Kt4",fastjet::kt_algorithm,0.4,false));
builder.add_default_alg( new FastJetFinder("Kt4_wArea",fastjet::kt_algorithm,0.4,true));
builder.add_default_alg( new SISConeFinder("SISCone4",0.4));
builder.add_default_alg( new D0::D0RunIIConeFinder("myD0Cone",true)); // D0's midpoint with second pass turned on

builder.configure_output("SpartyJet_Tree","../data/output/manyalgs.root");
builder.add_text_output("../data/output/text_manyalgs.dat");

builder.process_events(10);
}
