{
// ROOT libraries needed
gSystem->Load("libTree.so") ; // needed with recent ROOT version
gSystem->Load("libPhysics.so");
// Load the SpartyJet libraries that are needed
gSystem->Load("../libs/libJetCore.so");
gSystem->Load("../libs/libFastJet.so");
using namespace SpartyJet;

// Create a jet builder(MessageLevel = INFO)------
JetBuilder builder(INFO);

// Create input object and add to builder --------
StdTextInput input("../data/J1_Clusters.dat");
builder.configure_input((InputMaker*)&input);

// Create jet finder and add to builder ----------
FastJet::FastJetFinder *antikt4 = new FastJet::FastJetFinder("AntiKt4",fastjet::antikt_algorithm,0.4);
builder.add_default_alg(antikt4);

// Configure text output--------------------------
builder.add_text_output("../data/output/text_simple.dat");

// Configure ntuple output------------------------
builder.configure_output("SpartyJet_Tree","../data/output/simple.root");

// Run SpartyJet----------------------------------
builder.process_events(10);
}
