#!/usr/bin/env python

from  SpartyJetConfig import *
#===============================================

# Create a jet builder---------------------------
builder = SJ.JetBuilder()
builder.silent_mode() # turns off debugging information

# Configure input -------------------------------
input = SJ.StdTextInput('../data/J1_Clusters.dat')
builder.configure_input(input)

#**********************************************************************************
## Below are all the different ways one may use FastJet from within SpartyJet

## Run fastjet with SpartyJet handling jet definition
anti4 = SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4,False)
builder.add_default_alg(anti4)
## Same for SISCone
sis4 = SJ.FastJet.SISConeFinder('SISCone4',0.4,False)
builder.add_default_alg(sis4)

## Run fastjet by passing custom Jet Definiton to SpartyJet
anti7_def = fj.JetDefinition(fj.antikt_algorithm,0.7)
anti7 = SJ.FastJet.FastJetFinder(anti7_def, 'AntiKt7',False)
builder.add_default_alg(anti7)

## Run SISCone via included plugin algorithm
coneRadius = 0.7
overlapThreshold = 0.75
sisPlugin = fj.SISConePlugin(coneRadius, overlapThreshold)
sisPlugin_jet_def = fj.JetDefinition(sisPlugin)
sis7 = SJ.FastJet.FastJetFinder(sisPlugin_jet_def,'SISCone7',False)
builder.add_default_alg(sis7)

## User Plugin example
## If lib*.so is genereated as in ../fastjet/UserPlugins/ExamplePlugin/Makefile
## then lib*.so file must be included as follows: 
## (Note: must run make in ../fastjet/UserPlugins/ExamplePlugin/ first)
ROOT.gSystem.Load('../fastjet/UserPlugins/ExamplePlugin/libExamplePlugin.so')
## else one must place the Plugin's lib*.a file and header file
## as described in ../fastjet/UserPlugins/ lib/ and include/ respectively
## See documentation for more information
plugin = fj.ExamplePlugin(fj.JetDefinition(fj.antikt_algorithm,1.0))
plugin_jet_def = fj.JetDefinition(plugin)
exFinder = SJ.FastJet.FastJetFinder(plugin_jet_def,'ExamplePlugin',False)
builder.add_default_alg(exFinder)

## Other plugins shipped with fastjet
## To use these plugins one must:
## - uncomment the necessary lines in spartyjet/fastjet/FastJetLinkDef.hpp
## - recompile fastjet with ./configure --enable-allcxxplugins 
##   (not need to recompile if you use fastjet shipped with spartyjet)
## - recompile spartyjet/fastjet dir by doing: make fastjetC && make fastjet

## 3 examples, see fastjet docs for more

## CMS Iterative Cone Plugin
#coneRadius = 0.4
#seedThresh = 1.0
#cmsConePlugin = fj.CMSIterativeConePlugin(coneRadius,seedThresh)
#cmsCone_jet_def = fj.JetDefinition(cmsConePlugin)
#cmsCone = SJ.FastJet.FastJetFinder(cmsCone_jet_def,'CMSCone',False)
#builder.add_default_alg(cmsCone)

## Jade Plugin
#jPlugin = fj.JadePlugin()
#jPlugin_jet_def = fj.JetDefinition(jPlugin)
#jade = SJ.FastJet.FastJetFinder(jPlugin_jet_def,'Jade',False)
#builder.add_default_alg(jade)

## e-e Cambridge Plugin
#ycut = 0.4
#eecPlugin = fj.EECambridgePlugin(ycut)
#eecPlugin_jet_def = fj.JetDefinition(eecPlugin)
#eec = SJ.FastJet.FastJetFinder(eecPlugin_jet_def,'EECambridge',False)
#builder.add_default_alg(eec)


## Other plugins available not shipped with fastjet
## Installation can be done in either of the ExamplePlugin manners

### JetPruning: http://www.phys.washington.edu/groups/lhcti/pruning/FastJetPlugin/
#antikt10 = fj.JetDefinition(fj.antikt_algorithm,1.0)
#antiktBIG = fj.JetDefinition(fj.antikt_algorithm,3.14*0.5)
#prunePlugin = fj.FastPrunePlugin(antikt10,antiktBIG,0.1,0.5)
#pruneJetDef = fj.JetDefinition(prunePlugin)
#prune = SJ.FastJet.FastJetFinder(pruneJetDef,'Prune',False)
#builder.add_default_alg(prune)

## JetTrimming: http://jthaler.net/jets/Jet_Trimming.html 
#trimPlugin = fj.QCDTrimmingFast(fj.JetDefinition(2,1.5))
#trimPlugin.SetRsubPtfrac(0.2, 0.001)
#trimJetDef = fj.JetDefinition(trimPlugin)
#trim = SJ.FastJet.FastJetFinder(trimJetDef,'Trim',False)
#builder.add_default_alg(trim)


#**********************************************************************************

# Configure output--------------------------------
builder.add_text_output("../data/output/simple.dat")
builder.configure_output("SpartyJet_Tree","../data/output/simple.root");

# Run SpartyJet
builder.process_events(10)
