#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================

# Configure input -------------------------------
inputList = [] # List to store all types of input

# Text
textInput = SJ.StdTextInput('../data/J1_Clusters.dat')
inputList.append(textInput)

# Ntuple
ntupleInput = SJ.NtupleInputMaker(SJ.NtupleInputMaker.EtaPhiPtE_vector_float)
ntupleInput.set_prefix('Cluster_')
ntupleInput.set_n_name('N')
ntupleInput.set_variables('eta','phi','pt','e');
ntupleInput.setFileTree('../data/J2_clusters_wPile.root', 'clusterTree')
inputList.append(ntupleInput)

# HepMC
hepMCInput = SJ.HepMCInput('../data/HepMC_sample.dat')
inputList.append(hepMCInput)

# StdHep
stdHepInput = SJ.StdHepInput('../data/ttbar_smallrun_pythia_events.hep')
inputList.append(stdHepInput)

# CalChep
calChepInput = SJ.CalchepPartonTextInput('../data/gg_ggg_events.dat')
inputList.append(calChepInput)

#Les Houches Event format
lheInput = SJ.LheInput('../data/w1j.lhe')
inputList.append(lheInput)

updateResults = False # bool switch to update ROOT file in each loop after 1st
for input in inputList:
    print "Now running on",input.name()

    # Create a jet builder---------------------------
    builder = SJ.JetBuilder(SJ.WARNING)
    
    # Set the input----------------------------------
    builder.configure_input(input)

    # Configure algorithms --------------------------
    anti4 = SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4)
    builder.add_default_alg(anti4)

    # Configure output--------------------------------
    builder.configure_output(input.name()+"_Tree","../data/output/simple.root",updateResults);
    updateResults = True

    # Run SpartyJet
    builder.process_events(10)
