#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================

# Create a jet builder---------------------------
builder = SJ.JetBuilder(SJ.INFO)

# Configure input -------------------------------
input = SJ.StdHepInput('../data/ttbar_smallrun_pythia_events.hep')
builder.configure_input(input)

# To store time per algorithm
#builder.do_time_measure()

# To add soft ghost particles to jets (useful for event plots)
#builder.adding_active_ghosts(5000)

# Configure algorithms --------------------------
antikt4 = SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4,True)
antikt4.set_areaChoice(fj.active_area)
builder.add_default_alg(antikt4)
kt4 = SJ.FastJet.FastJetFinder('Kt4',fj.kt_algorithm,0.4,True)
kt4.set_areaChoice(fj.active_area)
builder.add_default_alg(kt4)
siscone4 = SJ.FastJet.SISConeFinder('SISCone4',0.4,True)
siscone4.set_areaChoice(fj.passive_area)
builder.add_default_alg(siscone4)
builder.add_default_alg(SJ.cdf.JetClustFinder('JetClu7'))

# Add Jet Tools ---------------------------------
# add_jetTool_front - Run before jet finding
# add_jetTool       - Run after  jet finding

# Select particles to be removed from input ( ex: neutrinos )
builder.add_jetTool_front(SJ.JetInputPdgIdSelectorTool(stdVector(-12,12)))

# Determine event-by-event ptDensity from soft activity in bins of eta
densityTool = SJ.FastJet.PtDensityTool("PtDensityTool", fj.kt_algorithm, 0.5, fj.active_area, stdVector(-4.,-2.,0.,2.,4.))
builder.add_jetTool_front(densityTool)
# Input min pt cut (Here only for one algorithm)
builder.add_jetTool_front(SJ.JetPtSelectorTool(1*input.getGeV()),'SISCone4')
# Inout eta cut
builder.add_jetTool_front(SJ.JetEtaCentralSelectorTool(-1.5,1.5))

#======Here is where the algorithms defined above will run ======

# Final pt cut
builder.add_jetTool(SJ.JetPtSelectorTool(7*input.getGeV()))
# Jet correction to pt according to area and pt density 
builder.add_jetTool(SJ.JetAreaCorrectionTool("AreaCorrTool"))
# Compute Y split values
builder.add_jetTool(SJ.FastJet.YSplitterTool(0.1,fj.kt_algorithm,2))
# Some geometric moments
builder.add_jetTool(SJ.EtaPhiMomentTool("EtaPhiMomTool"))
builder.add_jetTool(SJ.HullMomentTool("HullMomTool"))

# Convert from GeV to MeV (or revers)
builder.add_jetTool(SJ.EConversionTool("EConvTool", False)) # Convert to MeV

# Add Event Shape -------------------------------
thrustAlg = SJ.JetAlgorithm("thrustAlg")
thrustAlg.addTool(SJ.eventshape.ThrustTool("ThrustTool"))
builder.add_eventshape_alg(thrustAlg)

# Configure output--------------------------------
builder.add_text_output("../data/output/jetTool.dat")
builder.configure_output("SpartyJet_Tree","../data/output/jetTool.root");

# Run SpartyJet
builder.process_events()
