#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================
# The output of this example is the default input to guiExample.py


# Create a jet builder---------------------------
builder = SJ.JetBuilder()
builder.set_message_level(SJ.WARNING)

# Configure input -------------------------------
input = createNtupleInputMaker('../data/J2_clusters_wPile.root', inputprefix='Cluster')
input.set_name('Cluster')
builder.configure_input(input)


## Configure algorithms --------------------------
# Add FastJet algorithms
builder.add_default_alg(SJ.FastJet.FastJetFinder('Kt4',fj.kt_algorithm,0.4,True))
builder.add_default_alg(SJ.FastJet.FastJetFinder('CambAach4',fj.cambridge_algorithm,0.4))
builder.add_default_alg(SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4))
builder.add_default_alg(SJ.FastJet.SISConeFinder('SISCone4',0.4))
# Add CDF algorithms
builder.add_default_alg(SJ.cdf.JetClustFinder('JetClu7'))
builder.add_default_alg(SJ.cdf.MidPointFinder('MidPoint7'))
# Add D0 algorithms
builder.add_default_alg(SJ.D0.D0RunIIConeFinder('RunIICone5'))
# Add ATLAS algorithms
builder.add_default_alg(SJ.atlas.FastKtTool('FastKt7'))
builder.add_default_alg(SJ.atlas.ConeFinderTool('AtlasCone7'))
# Add Pythia CellJet algorithm
builder.add_default_alg(SJ.pythia.CellJetFinder('CellJet7'))
## ------------------------------------------------


#builder.add_jetTool_front(SJ.JetPtSelectorTool(1))

# Configure output--------------------------------
builder.configure_output("SpartyJet_Tree","../data/J2_clusters_wPile.SJ.root");

# Run SpartyJet
builder.process_events(10)
