#!/usr/bin/env python
from  SpartyJetConfig import *
from ROOT import TStopwatch
#===============================================

## -------------------------------------------------------------
# Define what we want to run 
fileList = ['../data/J2_clusters_wPile.root','../data/J2_clusters_wPile2.root']
input_treename = 'clusterTree'
output_dir = '../data/output/'
output_treename = 'SpartyJet_Tree'
nEvents = 10 # Events per file to use
## -------------------------------------------------------------

## Redefine this function according to needs
def build_input_maker(fname):
    input_maker = createNtupleInputMaker(fname, inputprefix='Cluster')
    return input_maker

## Redefine this function according to needs
def get_output_filename(inFile):
    ''' return output filename according to input filename f'''
    outFile = output_dir+inFile[inFile.rfind('/')+1:]
    return outFile.replace('.root', '.SJ.root')

# Define Jet Algorithms here
# ex: run three different size Kt algorithms
algList =[]
for s in [0.4, 0.5, 0.6]:
    alg = SJ.FastJet.FastJetFinder('Kt'+str(int(s*10)),fj.kt_algorithm,s)
    algList.append(alg)



# Loop through files and run SpartyJet
for f in fileList:
    print "Opening: ",f
    print "Results to be saved as: ",get_output_filename(f)

    # For measuring performance
    w=TStopwatch()
    w.Start()

    builder = SJ.JetBuilder()
    builder.silent_mode() # Turn off debugging information
    input_maker = build_input_maker(f)
    builder.configure_input(input_maker)
    builder.configure_output(output_treename,get_output_filename(f))

    for a in algList:
        builder.add_default_alg(a)

    # set the output variable names
    builder.change_jet_ouptut_var("Eta","Phi","Pt","E","m","ind","numC") 

    #builder.process_events() # all events or use -1 
    builder.process_events(nEvents)

    w.Stop()
    print 'Process Time for file: ', w.RealTime()

