#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================

# Create a jet builder---------------------------
builder = SJ.JetBuilder(SJ.INFO)

# Configure input -------------------------------
## Cluster input
input = createNtupleInputMaker('../data/J2_clusters_wPile.root', inputprefix='Cluster')

## Parton-level input
#input = createNtupleInputMaker('../data/Wenu3parton.root')
#input.set_pdgId_name('pdgId')

builder.configure_input(input)

# Configure algorithms --------------------------
anti4 = SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4,False)
builder.add_default_alg(anti4)

# Configure output--------------------------------
builder.configure_output("SpartyJet_Tree","../data/output/simple.root");

# Run SpartyJet
builder.process_events(10)
