#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================

# Create 2 jet builders for comparison with and without pileup
builder = SJ.JetBuilder()
builder.set_message_level(SJ.WARNING)
builder.print_event_every(10);

builderPile = SJ.JetBuilder()
builderPile.set_message_level(SJ.WARNING)
builderPile.print_event_every(10);

# Configure input -------------------------------
input = createNtupleInputMaker('../data/J2_clusters.root', inputprefix='Cluster')
builder.configure_input(input)

# Add the signal input to both builders
builder.configure_input(input)
builderPile.configure_input(input)

# Configure overlay ----------------------------
mbInput = SJ.NtupleInputMaker(SJ.NtupleInputMaker.EtaPhiPtE_vector_float)
mbInput.set_prefix('Cluster_')
mbInput.set_n_name('N')
mbInput.set_variables('eta','phi','p_T','e');
mbInput.setFileTree('../data/minbias.root', 'minbiasTree')
mbInput.set_name('Cluster') # Name of branches in output ntuple
numMinBias = 4

# Add the minbias events to one of the  builders
builderPile.add_minbias_events(numMinBias,mbInput,True) # Bool is whether to draw no. of mb events from poisson

# Configure algorithms --------------------------
anti7 = SJ.FastJet.FastJetFinder('AntiKt7',fj.antikt_algorithm,0.7,True)
builder.add_default_alg(anti7)
builderPile.add_default_alg(anti7)

# Determine pt density of sample with pileup
etaBins = stdVector(-4.,-2.,0.,2.,4.)
densityTool = SJ.FastJet.PtDensityTool("PtDensityTool",fj.kt_algorithm,0.5,fj.active_area,etaBins)
builderPile.add_jetTool_front(densityTool)

# Calculate area-bsed correction to jet pt
builderPile.add_jetTool(SJ.JetAreaCorrectionTool("AreaCorrTool"))

# Configure output of each builder 
# (Note the boolean in the second line tells SpartyJet to 
#  update the output file, this is needed to save both results)
builder.configure_output("SignalOnly_Tree","../data/output/overlay.root");
builderPile.configure_output("SignalPileup_Tree","../data/output/overlay.root",True);

# Run Each Builder
builder.process_events()
print "Now running with Minbias events overlaid"
builderPile.process_events()
