#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================
ROOT.gSystem.Load('libEG') # import common event gen lib

# Create a jet builder(MessageLevel = INFO)------
builder = SJ.JetBuilder(SJ.INFO)

######### PYTHIA8 #########
# Load Libraries
ROOT.gSystem.Load('libEGPythia8')
# Creat TPythia8 object
pythia = ROOT.TPythia8()
# Single W production
pythia.ReadString('WeakSingleBoson:ffbar2W = on')
# Force decay W->ev
pythia.ReadString("24:onMode = off")
pythia.ReadString("24:onIfAny = 11 12")
# UE
pythia.ReadString("PartonLevel:MI = off") 
# ISR,FSR, beam remnant
pythia.ReadString("PartonLevel:ISR = on") 
pythia.ReadString("PartonLevel:FSR = on")
pythia.ReadString("PartonLevel:Remnants = on")
# Hadronize
pythia.ReadString("HadronLevel:all = on")
# Initialize for LHC
pythia.Initialize(2212,2212, 7000.)
# Initialize for Tevatron
#pythia.Initialize( 2212, -2212, 1960.)
###########################


######### PYTHIA6 #########
## Load Library
#ROOT.gSystem.Load("libEGPythia6")
## Create TPythia8 object
#pythia = ROOT.TPythia6()
## Turn on W+jet production
#pythia.SetMSEL(14)
## Turn off all decay modes except W->e+nu
#decayChOff = [190,191,192,194,195,196,198,199,200,207,208]
#for dc in decayChOff:
#    pythia.SetMDME(dc,1,0)
## Turn on W->e+nu
#pythia.SetMDME(206,1,1)
## Initialize for LHC
#pythia.Initialize('cms','p+','p+',7000.)
## Initialize for Tevatron
##pythia.Initialize('cms','p+','p-',1960.)
###########################

# Create input object and add to builder --------
input = SJ.PythiaInput(pythia)

# Event Particle printout (Only usable in Pythia8)
#input.printEvent(True)

builder.configure_input(input)

# Create jet finder and add to builder ----------
antikt4 = SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4)
builder.add_default_alg( antikt4 ) 

# Configure text output--------------------------
builder.add_text_output("../data/output/simple.dat")

# Configure ntuple output------------------------
builder.configure_output("SpartyJet_Tree","../data/output/simple.root");

# Run SpartyJet----------------------------------
builder.process_events(10)
