#!/usr/bin/env python
from  SpartyJetConfig import *
#===============================================

# Create a jet builder(MessageLevel = INFO)------
builder = SJ.JetBuilder(SJ.INFO)

# Create input object and add to builder --------
input = SJ.StdTextInput('../data/J1_Clusters.dat')
builder.configure_input(input)

# Create jet finder and add to builder ----------
antikt4 = SJ.FastJet.FastJetFinder('AntiKt4',fj.antikt_algorithm,0.4)
builder.add_default_alg( antikt4 ) 

# Configure text output--------------------------
builder.add_text_output("../data/output/simple.dat")

# Configure ntuple output------------------------
builder.configure_output("SpartyJet_Tree","../data/output/simple.root");

# Run SpartyJet----------------------------------
builder.process_events(10)
