#ifndef _FASTJETFINDER_HH_
#define _FASTJETFINDER_HH_

#include "JetCore/JetTool.hh"
#include "fastjet/JetDefinition.hh"
#include "fastjet/AreaDefinition.hh"
#include "fastjet/PseudoJet.hh"
#include <string>

namespace fastjet {
class JetDefinition;
}

namespace SpartyJet {

class JetMomentMap;
namespace FastJet {

class FastJetFinder : public JetTool {
public :
  FastJetFinder(std::string name = "myFastJet",fastjet::JetAlgorithm alg = fastjet::kt_algorithm,double R = 0.4,bool area=false);
  FastJetFinder(fastjet::JetDefinition *jet_def, std::string name = "myFastJet", bool area = true);
  virtual ~FastJetFinder();
  
  void set_defaults(); // set default parameters; from old constructor
  void configure(fastjet::JetAlgorithm,bool,bool,bool,double,double,double);
  void set_algorithm(fastjet::JetAlgorithm alg, double R = 0.4);
  void set_area(bool x)            {m_area = x;}
  void set_areaChoice(fastjet::AreaType x)  {m_areaChoice = x;}
  void set_inclusive(bool x)       {m_inclusive = x;}
  void set_exclusive(bool x)       {m_exclusive = x;}
  void set_Rparam(double x)        {set_algorithm(m_jet_def->jet_algorithm(),x);}
  void set_ptmin(double x)         {m_ptmin   = x;}
  void set_dcut(double x)          {m_dcut = x;}

  void configure_area(double,int,double,double,double,double);
  void set_ghost_etamax(double x)  {m_ghost_etamax = x;}
  void set_repeat(int x)           {m_repeat = x;}
  void set_ghost_area(double x)    {m_ghost_area = x;}
  void set_grid_scatter(double x)  {m_grid_scatter = x;}
  void set_kt_scatter(double x)    {m_kt_scatter = x;}
  void set_mean_ghost_kt(double x) {m_mean_ghost_kt = x;}

  void set_history_building(bool x){m_updateHistory = x;}

  virtual bool contains_area()     {return m_area;}
  double getConeRadius()           {return m_jet_def->R();}

  virtual void init(JetMomentMap *mmap=0);
  virtual void execute(JetCollection &inputJets);
  virtual void finalize() {};


protected:
  bool m_area;
  fastjet::AreaType  m_areaChoice;
  bool m_inclusive;
  bool m_exclusive;

  //bool m_build_history;

  double m_ptmin;
  double m_dcut;

  // area parameters
  double m_ghost_etamax;
  int    m_repeat;
  double m_ghost_area;
  double m_grid_scatter;
  double m_kt_scatter;
  double m_mean_ghost_kt;

  bool m_use_ext_jet_def; // if true, we don't own the JetDefinition, and shouldn't mess with it

  fastjet::JetDefinition *m_jet_def;
};

}

}  // namespace SpartyJet
#endif
