#ifndef _JET_AREA_CORRECTION_TOOL_HH_
#define _JET_AREA_CORRECTION_TOOL_HH_

#include <string>
#include "JetCore/JetTool.hh"
#include "fastjet/JetDefinition.hh"
#include "fastjet/RangeDefinition.hh"
#include "fastjet/AreaDefinition.hh"
namespace SpartyJet { 

class JetMomentMap;
namespace FastJet { 

class PtDensityTool : public JetTool {
public:
  PtDensityTool(std::string name) : JetTool(name){};
  PtDensityTool(std::string name,fastjet::JetAlgorithm 	densAlg,float R,fastjet::AreaType area,std::vector<float> etaBins);
  PtDensityTool(std::string name,fastjet::JetDefinition *densDef,fastjet::AreaType area,std::vector<float> etaBins);
  PtDensityTool(std::string name,fastjet::JetDefinition *densDef,fastjet::AreaType area,std::vector<fastjet::RangeDefinition> *rangeDefVec);
	virtual void init(JetMomentMap *mmap) ;
	virtual void execute(JetCollection &inputJets) ;
	void 				 setDensityAlg(fastjet::JetDefinition *jDef) 	{ m_densDef= *jDef; }
	void 				 addRangeDef(fastjet::RangeDefinition *rDef) 	{ m_rangeDefVec.push_back( *rDef); }
	void				 setEtaBins(std::vector<float> etaBins);

private:
	fastjet::JetDefinition 		m_densDef;
	fastjet::AreaDefinition 	m_areaDef;
	std::vector<fastjet::RangeDefinition>	m_rangeDefVec;

};

}  // namespace FastJet

}  // namespace SpartyJet
#endif 
							
