#include "fastjet/PseudoJet.hh"
#include "fastjet/ClusterSequence.hh"
#include "fastjet/AreaDefinition.hh"
#include "fastjet/ActiveAreaSpec.hh"
#include "fastjet/ClusterSequenceArea.hh"
#include "fastjet/ClusterSequenceActiveArea.hh"
#include "fastjet/ClusterSequencePassiveArea.hh"
#include "fastjet/SISConePlugin.hh"
#include "JetCore/JetMomentMap.hh"
#include "JetCore/CommonUtils.hh"
#include <vector>

#include "SISConeFinder.hh"

namespace SpartyJet {

namespace FastJet {


SISConeFinder::SISConeFinder(std::string name,double r,bool a)
  : FastJetFinder(NULL, name, a)
{
  m_overlapThreshold = 0.75;
  m_nPassMax         = 0;
  m_protojetptmin    = 0.0;
  m_caching          = 0;
  m_coneRadius = r;

  m_updateHistory = false; // do not turn this on!

  m_saveSplitMerged  = false;

  init();
}
    
SISConeFinder::~SISConeFinder()
{
	delete m_jet_def; m_jet_def = NULL;
	delete m_plugin; m_plugin = NULL;
}

void SISConeFinder::init(JetMomentMap *mmap) {
  if(mmap != NULL) {
    //    if(saveSplitMerged) mmap->schedule_jet_moment("split_merged");
    if(m_area) {
      mmap->schedule_jet_moment("area");
      mmap->schedule_jet_moment("area_error");
    }
  }

  m_plugin = new fastjet::SISConePlugin(m_coneRadius,m_overlapThreshold,m_nPassMax,m_protojetptmin,m_caching);
  if(m_jet_def != NULL) delete m_jet_def;
  m_jet_def = new fastjet::JetDefinition(m_plugin);
}

void SISConeFinder::configure(bool a,bool in, bool ex,double cr,double ot,int n,double pt,int c) {
  m_area             = a;
  m_inclusive        = in;
  m_exclusive        = ex;
  m_coneRadius       = cr;
  m_overlapThreshold = ot;
  m_nPassMax         = n;
  m_protojetptmin    = pt;
  m_caching          = c;
  init();
}


}  // namespace fastjet
} // namespace SpartyJet

