#ifndef _SISCONEFINDER_HH_
#define _SISCONEFINDER_HH_

#include "JetCore/JetTool.hh"
#include "FastJetFinder.hh"
#include <string>

namespace fastjet {
  class SISConePlugin;
}

namespace SpartyJet { 

namespace FastJet {

//class SISConeFinder : public JetTool {
class SISConeFinder : public FastJetFinder {
public :
  SISConeFinder(std::string name = "mySISCone",double R=0.4,bool area=false);
  virtual ~SISConeFinder();

  void configure(bool,bool,bool,double,double,int,double,int);

  void set_coneRadius(double x)       {m_coneRadius = x;}
  void set_overlapThreshold(double x) {m_overlapThreshold = x;}
  void set_nPassMax(int x)            {m_nPassMax = x;}
  void set_ptmin(double x)            {m_protojetptmin = x;}
  void set_caching(int x)             {m_caching = x;}
  void set_saveSplitMerged(bool x)    {m_saveSplitMerged  = x; 
                                       std::cout << "SplitMerge saving is no longer supported in SISCone!\n";}

  void set_history_building(bool x) {std::cout << "SISConeFinder::set_history_building(): History not meaningful for SISCone!\n";}

  virtual void init(JetMomentMap *mmap=0);
  //virtual void execute(JetCollection &inputJets);
  virtual void finalize() {};

protected:
  bool   m_saveSplitMerged;
  double m_coneRadius;
  double m_overlapThreshold;
  int    m_nPassMax;
  double m_protojetptmin;
  int    m_caching;

	fastjet::SISConePlugin *m_plugin;
};


} // namespace fastjet

}  // namespace SpartyJet
#endif
