#ifndef _YSPLITTERTOOL_HH_
#define _YSPLITTERTOOL_HH_

#include "FastJetFinder.hh"
#include "JetCore/JetTool.hh"
#include <string>

namespace SpartyJet { 

namespace FastJet {
class YSplitterTool : public  JetTool {
public :

  YSplitterTool(std::string name="YSplitter") : JetTool(name) {};
  YSplitterTool(float R, fastjet::JetAlgorithm alg, int ny, int njet=-1, std::string name="YSplitter" );
  YSplitterTool(fastjet::JetDefinition *jet_def, int ny, int njet=-1, std::string name="YSplitter" );

  // Maximum number of y-values
	static const  int MAX=4;

  virtual void init(JetMomentMap *mmap=0);
  virtual void execute(JetCollection &inputJets);
  virtual void finalize();

  void configure(int ny, int njet=-1);
  void set_n_values(int x)  {m_nvalues = x;}
  void set_n_jets(int n)    {m_njets = n;}

  //std::vector<float> getYvals(Jet* inputJet);

private:

  // Jet Description used for clustering of constituents
	fastjet::JetDefinition* m_jet_def;

  // Number of yvalues per jets
  int m_nvalues;

  // Number of jets for which Yvalues are computed (by default :-1 == all)
  int m_njets;
  
};

}
}  // namespace SpartyJet
#endif
